import os

from sandbox import sdk2 as sb


def download(resource_id):
    return str(sb.ResourceData(resource_id).path)


def get_resource(resource_id):
    return list(sb.Resource.find(id=resource_id).limit(1))[0]


def attr_dict(o, attrs):
    return {k: getattr(o, k) for k in attrs if hasattr(o, k)}


class COPY_RESOURCE(sb.Task):
    """
    Provide an existing resource from a new task.
    """

    class Parameters(sb.Task.Parameters):
        resource = sb.parameters.Resource('Resource', required=True)

    def on_execute(self):
        src = get_resource(self.Parameters.resource.id)
        src_path = download(self.Parameters.resource)
        dst = sb.ResourceData(src.type(
            task=self,
            description=src.description,
            path=src.path.name,
            arch=src.arch,
            **attr_dict(src, ('platform', 'version'))
        ))
        os.link(src_path, str(dst.path))
        dst.ready()
