import os
import re

from sandbox import sdk2
from sandbox.projects.common.vcs.arc import Arc


class CacheTestPrCreator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        arc_user = sdk2.parameters.String('Arc user. Default: task author')
        branch_name = sdk2.parameters.String('branch_name', default='ymake_cache_test')
        file_name = sdk2.parameters.String('file_name', required=True)

    def on_execute(self):
        arc_user = self.Parameters.arc_user or self.author
        branch_name = self.Parameters.branch_name
        upstream_branch = 'users/{}/{}'.format(arc_user, branch_name)

        arc = Arc()
        with arc.mount_path('', 'trunk', fetch_all=False) as mount_point:
            self._patch_file(mount_point)
            arc.checkout(mount_point=mount_point, branch=branch_name, create_branch=True)
            arc.commit(mount_point=mount_point, message='Dummy commit message', all_changes=True)
            arc.push(mount_point=mount_point, upstream=upstream_branch, force=True)
            pr = arc.pr_create(mount_point=mount_point, message='Initiate ymake cache tests', auto=True, no_commits=True)
            self.set_info('Created PR:\n{}'.format(pr))

    def _patch_file(self, mount_point):
        file_to_change = os.path.join(mount_point, self.Parameters.file_name)
        with open(file_to_change) as f:
            content = f.read()
        new_content = re.sub(r'return (\w+) \+ (\w+);', r'return \2 + \1;', content)
        with open(file_to_change, 'w') as f:
            f.write(new_content)
