# -*- coding: utf-8 -*-
import os
import shutil
import subprocess

from sandbox import sdk2
import sandbox.projects.common.arcadia.sdk as arcadia_sdk


PLUGIN_RELEASERS = [
    'albazh',
    'andreevdm',
    'avhaliullin',
    'skel',
    'miroslav2',
    'andreybystrov',
    'thevery',
    'nogert',
    'spasitel',
    'muldrik'
]


class INTELLIJ_PLUGIN(sdk2.Resource):
    """ Devtools / Arcanum IntelliJ Plugin """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = PLUGIN_RELEASERS

    version = sdk2.parameters.String("Plugin version from plugin.xml, build.gradle, updatePlugin", required=True)
    idea_version = sdk2.parameters.String("IDEA target platform version (e.g. 201)", required=True)
    since_idea_version = sdk2.parameters.String("IDEA min version for plugin", default='173.0')
    until_idea_version = sdk2.parameters.String("IDEA max version for plugin", default='')


class BUILD_INTELLIJ_PLUGIN(sdk2.Task):
    """ Build Intellij plugin """
    class Requirements(sdk2.Requirements):
        disk_space = 2 * 1024   # 2 GiB
        ram = 1 * 1024          # 1 GiB

    class Parameters(sdk2.Parameters):
        arcadia_url = sdk2.parameters.String('Arcadia URL', default='arcadia-arc:/#trunk')

    def on_execute(self):
        with arcadia_sdk.mount_arc_path(self.parameters.arcadia_url) as arcadia:
            plugin_path = os.path.join(arcadia, 'devtools', 'intellij')

            subprocess.check_call(
                ['./gradlew', 'build', '--no-daemon'],
                cwd=plugin_path,
                env={'JAVA_OPTS': '-Djava.net.preferIPv6Addresses=true'}
            )

            build_directory = os.path.join(plugin_path, 'build', 'libs')

            files = os.listdir(build_directory)

            assert len(files) == 1

            shutil.copy(os.path.join(build_directory, files[0]), 'intellij-plugin.jar')

        resource = INTELLIJ_PLUGIN(self, "Intellij plugin", 'intellij-plugin.jar')
        sdk2.ResourceData(resource).ready()
