import json
import os

# XXX: self.make_context_on_distbuild
DEFAULT_INPUT_PARTITION_PARAMS = {
    'acceptance_task': False,
    'add_changed_ok_configures': True,
    'arc_binary_path': '',
    'arc_token': '',
    'arcadia_patch': '',
    'arcadia_patch_for_in_compare_repo_state': '',
    'autocheck_build_type': 'Release',
    'autocheck_build_vars': '',
    'autocheck_config_path': '',
    'autocheck_distbs_testing_cluster': False,
    'autocheck_distbs_testing_cluster_id': '',
    'autocheck_logs_resource_ttl': 7,
    'autocheck_make_only_dirs': 'autocheck',
    'autocheck_revision': 0,
    'autocheck_toolchain_new': '',
    'autocheck_ymake_rebuild': False,
    'backup_tests_results': True,
    'build_left_right_graph': False,
    'cache_namespace': 'AC',
    'cache_tests': True,
    'check_yp_hosts': False,
    'checkout_arcadia_from_url': 'arcadia-arc',
    'checkout_arcadia_from_url_for_in_compare_repo_state': '',
    'ci_check_id': '',
    'ci_check_type': '',
    'ci_iteration_number': 1,
    'ci_logbroker_source_id': '',
    'ci_logbroker_topic': '',
    'ci_task_id': '',
    'circuit_type': 'full',
    'commit_author': '',
    'coordinators_filter': '',
    'custom_targets_list': '',
    'distbs_max_queue_position': 400,
    'distbs_pool': '',
    'distbs_timeout': 3600,
    'distbuild_fixed_priority': -1,
    'distbuild_priority': -1,
    'do_not_download_tests_results': True,
    'emulate_streaming': False,
    'gg_coordinators_filter': '',
    'gg_distbs_pool': '',
    'host_platform': '',
    'host_platform_flags': 'ALLOCATOR=LF;USE_EAT_MY_DATA=yes',
    'ignored_toolchains': [],
    'is_precommit': False,
    'is_autocheck_20': False,
    'is_trunk': True,
    'json_prefix': '',
    'keep_all_logs_and_files': False,
    'make_context_on_distbuild_requirements': '{\'mlock\': 150,\'cpu\': 2}',
    'merge_split_tests': False,
    'native_build_targets': '',
    'normalized_dist_priority': 0,
    'projects_partition_index': 0,
    'projects_partitions_count': 1,
    'recheck': False,
    'remove_result_node': False,
    'report_namespace': '',
    'report_skipped_suites': True,
    'report_skipped_suites_only': False,
    'report_to_ci': True,
    'run_tests': False,
    'sandboxing': False,
    'save_graph_and_context': False,
    'save_meta_graphs': False,
    'send_logs_to_logbroker': True,
    'should_pessimize_by_nodes': False,
    'stop_after_meta_graph': False,
    'streaming_backends': '',
    'streaming_check_id': '',
    'stress_test': False,
    'target_platforms': '',
    'test_size_timeout': {},
    'test_sizes': [
        'small',
        'medium'
    ],
    'test_type_filters': [],
    'tests_retries': 1,
    'toolchain_transforms': {},
    'trust_cache_fs': False,
    'use_custom_context': True,
    'use_dist_diff': True,
    'use_imprint_cache': True,
    'use_in_compare_repo_state': False,
    'use_strace': False,
    'use_streaming': False,
    'use_ymake_cache': 'parser',
    'used_ymake_cache_kind': 'parser',  # TODO: Will be removed soon YA-27
    'used_ymake_minimal_cache_kind': None,
    'with_profile': False,
    'ya_bin_token': '',
    'ymake_cache_kind': 'parser',
}


# XXX: self.make_context_on_distbuild
DEFAULT_INPUT_AUTOCHECK_YA_2_PARAMS = {
    # 'checkout_arcadia_from_url': '',
    # 'arcadia_patch': '',
    'is_precommit': False,
    'use_custom_context': True,
    'is_trunk': True,
    'normalized_dist_priority': 0,

    # 'Build parameters
    'json_prefix': '',
    # 'autocheck_config_path': '',
    'autocheck_build_type': 'Release',
    'autocheck_ymake_rebuild': False,
    'autocheck_build_vars': 'NO_DEBUGINFO=yes;AUTOCHECK=yes',
    'host_platform': '',
    'host_platform_flags': 'ALLOCATOR=LF;USE_EAT_MY_DATA=yes',
    'target_platforms': '',
    'toolchain_transforms': '',
    'ignored_toolchains': '',
    'recheck': False,
    'autocheck_make_only_dirs': 'autocheck',
    'custom_targets_list': '',
    # 'projects_partitions_count': 1,
    # 'projects_partition_index': 0,
    'cache_namespace': 'AC',
    'use_ymake_cache': None,  # Special value for heater
    'used_ymake_cache_kind': None,  # TODO: Will be removed soon YA-27
    'used_ymake_minimal_cache_kind': None,
    'ymake_cache_kind': 'parser',  # Special value for heater
    'use_imprint_cache': False,  # Special value for heater
    'trust_cache_fs': False,  # Special value for heater
    'with_profile': False,
    'sandboxing': False,

    # Test parameters
    'run_tests': False,
    'report_skipped_suites': True,
    'report_skipped_suites_only': False,
    'do_not_download_tests_results': True,
    'backup_tests_results': True,
    'cache_tests': True,
    'tests_retries': 1,
    'test_sizes': ['small', 'medium', ],
    'test_size_timeout': {},
    'test_type_filters': [],
    'merge_split_tests': False,
    'remove_result_node': False,

    # Distbuild parameters
    'distbs_timeout': 3600,
    'coordinators_filter': '',
    'make_context_on_distbuild_requirements': '',
    'autocheck_distbs_testing_cluster': False,
    'autocheck_distbs_testing_cluster_id': '',
    'use_new_distbuild_client': False,
    'use_new_distbuild_client_prob': 0,
    'use_arcc_in_distbuild': False,
    'distbs_pool': '',

    # Streaming parameters
    'use_streaming': False,
    'streaming_backends': '',
    'streaming_check_id': '',

    # Task parameters
    'report_namespace': '',
    'use_strace': False,
    'keep_all_logs_and_files': False,
    'save_meta_graphs': False,
}

DEFAULT_ENV_AUTOCHECK_YA_2_PARAMS = {
    'YA_STRIP_PACKAGES_FROM_RESULTS': '1',
    'YA_NO_GEN_RENAMED_RESULTS': '1',
    'YA_GRAPH_GEN_DIST_PRIORITY': '-1',
    'TOOLCHAIN': '',
    'YA_NO_RESPAWN': '1',
    'AUTOCHECK': '1',
}

# testenv/jobs/autocheck/BaseBuildTrunkMeta.py
# default value for params.autocheck_make_only_dirs in ConfigOptions::__init__
DEFAULT_MAKE_ONLY_DIRS = ["autocheck"]
# default value for params.autocheck_build_type in ConfigOptions::__init__
DEFAULT_BUILD_TYPE = "Release"
# default value for params.autocheck_build_vars in ConfigOptions::__init__
DEFAULT_BUILD_VARS = ["NO_DEBUGINFO=yes", "AUTOCHECK=yes"]
# default value for params.host_platform_flags in ConfigOptions::__init__
DEFAULT_HOST_PLATFORM_FLAGS = ['ALLOCATOR=LF', 'USE_EAT_MY_DATA=yes', ]
# End of testenv/jobs/autocheck/BaseBuildTrunkMeta.py

# Parameters responsible to configuration of children:
# params.autocheck_config_path, params.projects_partition_index, params.projects_partitions_count
# collected from testenv/jobs/autocheck/*.py
# params.autocheck_config_path, params.projects_partitions_count
DEFAULT_PARTITION_ARGUMENTS = [
    ['autocheck/autocheck-config-linux.json', 12],
    ['autocheck/autocheck-config-sanitizers.json', 6],
    ['autocheck/autocheck-config-ios-android-cygwin.json', 1],
    ['autocheck/autocheck-config-gcc-msvc-musl.json', 1],
    ['autocheck/autocheck-config-mandatory-platforms.json', 1],
    ['autocheck/autocheck-config-aux-subset-3.json', 1],
]


# Filtered out sandbox/projects/autocheck/AutocheckBuildYa/__init__.py::AutocheckOptions
# sandbox/projects/autocheck/AutocheckBuildYa/builders/ymake.py::YaOptions
class ConfigOptions(object):
    def __init__(self, source_root, params):
        """
            Only parameters related to build graph generation are handled (--target*, --host-platform-flag*, --build, -D* and -C*, --cache-tests, --warning-mode):

            params.autocheck_make_only_dirs (-C*)
            params.autocheck_build_type (--build)
            params.autocheck_build_vars (-D*)
            params.host_platform_flags (--host-platform-flag*)

            Remaining parameters affect -D*, --host-platform-flag*, --target*:
            params.autocheck_config_path
            params.projects_partition_index
            params.projects_partitions_count
        """
        self._source_root = source_root

        if not isinstance(params.autocheck_make_only_dirs, list):
            self._targets = params.autocheck_make_only_dirs.split(';')
        else:
            self._targets = params.autocheck_make_only_dirs
        self._targets = filter(None, self._targets)

        self._build_type = params.autocheck_build_type.lower()

        if not isinstance(params.autocheck_build_vars, list):
            self._build_vars = params.autocheck_build_vars.split(';')
        else:
            self._build_vars = params.autocheck_build_vars
        self._build_vars = filter(None, self._build_vars)

        if not isinstance(params.host_platform_flags, list):
            self._host_platform_flags = params.host_platform_flags.split(';')
        else:
            self._host_platform_flags = params.host_platform_flags
        self._host_platform_flags = filter(None, self._host_platform_flags)

        self._config_path = params.autocheck_config_path
        self._partition_index = params.projects_partition_index
        self._partitions_count = params.projects_partitions_count

        with open(os.path.join(self._source_root, self._config_path)) as fp:
            self._autocheck_config = json.load(fp)

        if 'autocheck_build_vars' in self._autocheck_config:
            self._build_vars = self._autocheck_config['autocheck_build_vars']
        if 'host_platform_flags' in self._autocheck_config:
            self._host_platform_flags = self._autocheck_config['host_platform_flags']

        self._target_platforms = filter(None, self._autocheck_config['target_platforms'])
        if self._partitions_count > 1:
            self._build_vars += [
                'RECURSE_PARTITIONS_COUNT={}'.format(self._partitions_count),
                'RECURSE_PARTITION_INDEX={}'.format(self._partition_index),
            ]

    def gen_options(self):
        from yalibrary import platform_matcher

        # Generate consistent UIDS for test nodes.
        result = ['--cache-tests']
        result += ['--warning-mode', ';'.join(['dirloops', 'ChkPeers', 'allbadrecurses'])]
        result += ['--backup-test-results', '--no-src-links', '--add-modules-to-results',
                   '--do-not-output-stderrs', '--dont-merge-split-tests',
                   '--strip-packages-from-results', '--report-skipped-suites', '--output-only-tests']

        if self._targets:
            result += ['-C', ';'.join(self._targets)]
        if self._build_vars:
            result += ['-D{var}'.format(var=var) for var in self._build_vars]
        if self._host_platform_flags:
            result += sum([['--host-platform-flag', var] for var in self._host_platform_flags], [])
        if self._target_platforms:
            result += sum([platform_matcher.make_platform_params(pl) for pl in self._target_platforms], [])
        if self._build_type:
            result += ['--build', self._build_type]

        return result
