from sandbox import sdk2
from .autocheck_params import DEFAULT_MAKE_ONLY_DIRS


class YMakeCacheDir(sdk2.Resource):
    """ Cache resource, see params from sandbox/projects/autocheck/AutocheckPartition/__init__.py"""

    # common attributes
    releasable = True
    any_arch = True
    ttl = 2
    sync_upload_to_mds = True

    # Custom attributes
    arc_commit_id = sdk2.parameters.String("arc_commit_id", default="")
    svn_revision = sdk2.parameters.Integer("svn_revision", default=0)
    autocheck_make_only_dirs = sdk2.parameters.String('autocheck_make_only_dirs', default=DEFAULT_MAKE_ONLY_DIRS)
    autocheck_config_path = sdk2.parameters.String("autocheck_config_path", default="")
    projects_partition_index = sdk2.parameters.Integer("projects_partition_index", default=0)
    projects_partitions_count = sdk2.parameters.Integer("projects_partitions_count", default=1)
    ymake_cache_kind = sdk2.parameters.String('ymake_cache_kind', default="parser")

    # Each heater task is not released, only its executor. Mark resource accordingly.
    parent_task_executor_released = sdk2.parameters.String('parent_task_executor_released', default="none")


class YMakeCacheTestResult(sdk2.Resource):
    # common attributes
    releasable = True
    any_arch = True
    ttl = 2

    test_directory = sdk2.parameters.String("test_directory", default="")
    test_pattern = sdk2.parameters.String("test_pattern", default="")
