import os

from .autocheck_params import ConfigOptions
from .autocheck_params import DEFAULT_MAKE_ONLY_DIRS, DEFAULT_BUILD_VARS, DEFAULT_BUILD_TYPE, DEFAULT_HOST_PLATFORM_FLAGS  # noqa
from .autocheck_params import DEFAULT_PARTITION_ARGUMENTS  # noqa


class ConfigYaMakeOptions(ConfigOptions):
    def __init__(self, source_root, output_dir, build_root, cache_archive, params):
        super(ConfigYaMakeOptions, self).__init__(source_root, params)

        self._output_dir = output_dir
        self._build_root = build_root
        self._cache_archive = cache_archive
        self._heater_flags = params.heater_flags

    def gen_options(self):
        result = ['--threads', '0', '-T', '--dist', '--keep-going', '--no-src-links']
        result += super(ConfigYaMakeOptions, self).gen_options()
        result += ['--build-graph-cache-archive', self._cache_archive, '--build-graph-cache-heater'] + self._heater_flags
        result += ['--stat', '--stat-dir', os.path.join(self._output_dir, 'build-statistics')]
        result += ['--build-dir', self._build_root]
        result += ['--source-root', self._source_root]
        return result

    def _ya_bin_path(self, use_ya_bin):
        return os.path.join(self._source_root, 'devtools', 'ya', 'bin', 'ya-bin') if use_ya_bin else os.path.join(self._source_root, 'ya')

    def gen_cmd(self, use_ya_bin=False):
        return [self._ya_bin_path(use_ya_bin=use_ya_bin), '-v', '--no-report', 'make'] + self.gen_options()
