# TODO get rid of all this sht - mine toolchain flags from autocheck/*.json files and use Autocheck mappings

COMMON_FLAGS = [
    "AUTOCHECK=yes",
    "NO_DEBUGINFO=no",
    "NO_SVN_DEPENDS=yes",
    "USE_EAT_MY_DATA=yes",
]

DEFAULT_BUILD_TYPE = "relwithdebinfo"
DEFAULT_TARGET_PLATFORM = "default-linux-x86_64"

TOOLCHAIN_MAP = {
    "clang8-darwin-x86_64-maps-mobile": {
        "platform": "xcode_11_1-darwin-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "clang8-ios-x86_64-maps-mobile": {
        "platform": "xcode_11_1-ios-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "default-android-i686-maps-mobile": {
        "platform": "default-android-i686",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "default-android-x86_64-maps-mobile": {
        "platform": "default-android-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "default-darwin-x86_64-maps-mobile": {
        "platform": "default-darwin-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "default-ios-x86_64-maps-mobile": {
        "platform": "default-ios-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "local-ios-x86_64": {
        "platform": "local-ios-x86_64",
        "flags": [
            "MAPSMOBI_BUILD_TARGET=yes",
        ],
        "exotic": True,
    },
    "default-darwin-x86_64-release": {
        "build_type": "release",
        "platform": "default-darwin-x86_64",
        "exotic": True,
    },
    "default-linux-x86_64-release": {
        "build_type": "release",
    },
    "default-linux-x86_64-release-asan": {
        "build_type": "release",
        "flags": [
            "SANITIZER_TYPE=address",
        ],
    },
    "default-linux-x86_64-release-fuzzing": {
        "build_type": "release",
        "flags": [
            "FUZZING=yes",
            "SANITIZER_CFLAGS=-fsanitize=fuzzer",
            "SANITIZER_TYPE=address",
        ],
    },
    "default-linux-x86_64-release-jdk15": {
        "build_type": "release",
        "flags": [
            "JDK_VERSION=15",
        ],
    },
    "default-linux-x86_64-release-jdk16": {
        "build_type": "release",
        "flags": [
            "JDK_VERSION=16",
        ],
    },
    "default-linux-x86_64-release-msan": {
        "build_type": "release",
        "flags": [
            "SANITIZER_TYPE=memory",
        ],
    },
    "default-linux-x86_64-release-musl": {
        "build_type": "release",
        "flags": [
            "MUSL=yes",
        ],
    },
    "default-linux-x86_64-release-ubsan": {
        "build_type": "release",
        "flags": [
            "SANITIZER_TYPE=undefined",
        ],
    },
    "default-linux-x86_64-relwithdebinfo": {},
    "default-linux-x86_64-system-python-27": {
        "flags": [
            "USE_SYSTEM_PYTHON=2.7",
        ]
    },
    "default-linux-x86_64-system-python-35": {
        "flags": [
            "USE_SYSTEM_PYTHON=3.5",
        ]
    },
    "default-linux-x86_64-system-python-36": {
        "flags": [
            "USE_SYSTEM_PYTHON=3.6",
        ]
    },
    "default-win-x86_64-debug": {
        "platform": "DEFAULT-WIN-X86_64",
        "build_type": "debug",
        "native": True,
    },
}


def get_platform_flags(toolchain, tags, target):
    import test.const as tconst

    tc = get_toolchain_spec(toolchain)
    if tc is None:
        raise AssertionError("Don't known how to mine platform flags for unknown toolchain: %s" % toolchain)

    opts = [
        "--target-platform {}".format(tc.get("platform", DEFAULT_TARGET_PLATFORM)),
        "--target-platform-build-type {}".format(tc.get("build_type", DEFAULT_BUILD_TYPE)),
    ]

    flags = COMMON_FLAGS + tc.get("flags", [])

    # XXX Hacks section
    if tconst.YaTestTags.YtRunner in tags:
        if toolchain in (
            "default-linux-x86_64-release",
            "default-linux-x86_64-relwithdebinfo",
        ):
            flags.append("RUN_TAGGED_TESTS_ON_YT=yes")

    if not target.startswith("yt/"):
        flags.append("DEBUGINFO_LINES_ONLY=yes")

    opts.extend(["--target-platform-flag {}".format(x) for x in flags])

    return " ".join(sorted(opts))


def get_toolchain_spec(name):
    return TOOLCHAIN_MAP.get(name)
