import datetime
import logging

from sandbox.sdk2 import statistics


def get_ya_make_task_duration(task):
    try:
        task_times = task.read()['time']
        start = datetime.datetime.strptime(task_times['created'], "%Y-%m-%dT%H:%M:%S.%fZ")
        finish = datetime.datetime.strptime(task_times['updated'], "%Y-%m-%dT%H:%M:%S.%fZ")
        return (finish - start).total_seconds()
    except:
        logging.exception('Cannot prepare metrics: YA_MAKE duration')
        return None


def get_build_and_test_times(task):
    try:
        build_time = 0
        test_time = 0
        task_stat = task.context.read()[statistics.TASK_STAT]
        if 'arcadiasdk_only_build_time' in task_stat:
            build_time = task_stat['arcadiasdk_only_build_time']['time']
        if 'arcadiasdk_test_time' in task_stat:
            test_time = task_stat['arcadiasdk_test_time']['time']
        return build_time, test_time
    except:
        logging.exception('Cannot prepare metrics: build and test times')
        return None, None


def get_ya_build_threads(task):
    try:
        task_stat = task.context.read()[statistics.TASK_STAT]
        return task_stat.get('ya_build_threads', 0)
    except:
        logging.exception('Cannot prepare metrics: ya build threads')
        return None
