import json
import logging

logger = logging.getLogger(__name__)


def convert_native_results(test_results, native_specification_json):
    def norm_path(p):
        return p.replace("\\", "/")

    for x in test_results:
        if "path" in x:
            x["path"] = norm_path(x["path"])

    native_specification = json.loads(native_specification_json)
    targets = native_specification.get('targets')
    assert targets, "No targets specified"

    results = []
    test_results_dict = dict((result.get('path'), result) for result in test_results)
    for target_key in targets:
        target = targets.get(target_key)
        result = test_results_dict.get(
            target_key, {"status": "FAILED", "error_type": "REGULAR", "rich-snippet": "missing"}
        )

        hid = int(target.get('hid'))
        results.append(
            {
                "hid": hid,
                "id": str(hid),
                "name": "native_build",
                "owners": {
                    "logins": result.get('owners', {}).get('logins', []),
                    "groups": result.get('owners', {}).get('groups', []),
                },
                "path": target_key,
                "status": result.get('status'),
                "suite_status": result.get('status'),
                "suite": True,
                "toolchain": result.get("toolchain", 'native_build'),
                "type": "native_build",
                "rich-snippet": result.get('rich-snippet', ''),
                "uid": result.get('uid', ''),
            }
        )

    return results
