from sandbox import sdk2

import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.YaMake2 as YaMake2


class NativeTargetParameter(sdk2.parameters.String):
    name = 'native_target'
    description = 'Native target'
    default_value = ''


class NativeSpecParameter(sdk2.parameters.String):
    # example: {"targets": {"devtools/ymake": {"hid": 1}}}
    name = 'native_spec'
    description = 'Native specification [json]'
    default_value = ''


# Group
class NativePlatform(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Native platform:") as native_group:
        native_target = NativeTargetParameter()
        native_specification = NativeSpecParameter()


class TestSuiteInfo(sdk2.parameters.String):
    name = 'expected_test_info'
    description = 'Test suite info (json-like string)'
    default_value = '{}'


class Targets(sdk2.parameters.String):
    name = 'targets'
    description = 'Targets'
    default_value = ''


# Group
class TestSpec(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Test specification:") as testspec_group:
        targets = Targets()
        expected_test_info = TestSuiteInfo()


class ArcadiaUrlParameter(sdk2.parameters.String):
    name = consts.ARCADIA_URL_KEY
    description = 'Arcadia url'
    # Task should be able to work with arc and svn (ya:nofuse),
    # that's why we use universal url compatible with both vcs
    default_value = 'arcadia:/arc/trunk/arcadia'


class ArcadiaBaseParameter(sdk2.parameters.Integer):
    name = 'arcadia_base'
    description = 'Arcadia SVN Base revision'
    default_value = 0


class ArcadiaPatchParameter(sdk2.parameters.String):
    name = consts.ARCADIA_PATCH_KEY
    description = 'Arcadia patch'
    default_value = ''


# Group
class Repository(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Repository:") as repo_group:
        arcadia_url = ArcadiaUrlParameter()
        arcadia_base = ArcadiaBaseParameter()
        arcadia_patch = ArcadiaPatchParameter()


class PrecommitParameter(sdk2.parameters.Bool):
    name = 'is_precommit'
    description = 'Precommit'
    default_value = False


class AutocheckRevision(sdk2.parameters.Integer):
    name = 'autocheck_revision'
    description = "Autocheck revision (will be used to calculate distbuild priority if svn-revision is not specify in the arcadia_url)"


class StreamReportUrl(sdk2.parameters.String):
    name = consts.STREAMING_REPORT_URL
    description = 'CI Stream report url'
    default_value = ''


class StreamReportId(sdk2.parameters.String):
    name = consts.STREAMING_REPORT_ID
    description = 'CI Stream report url'
    default_value = ''


# Group
class Autocheck(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Autocheck:") as autocheck_group:
        is_precommit = PrecommitParameter()
        autocheck_revision = AutocheckRevision()
        streaming_check_id = StreamReportId()
        streaming_link = StreamReportUrl()


class DebugTaskIds(sdk2.parameters.String):
    name = "debug_task_ids"
    description = "Use specified task_ids instead of running subtask (;-separated)"
    default_value = ""


class DebugAllTestTag(sdk2.parameters.Bool):
    name = "debug_all_test_tag"
    description = "Run all tests"
    default_value = False


class BinaryExecutorReleaseType(sdk2.parameters.String):
    name = "binary_executor_release_type"
    description = name
    default_value = "custom"


# Group
class DebugParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Task debug options:") as debug_group:
        binary_executor_release_type = BinaryExecutorReleaseType()
        debug_task_ids = DebugTaskIds()
        debug_all_test_tag = DebugAllTestTag()


class Parameters(sdk2.Task.Parameters):
    repository = Repository()
    test_spec = TestSpec()
    native_build = NativePlatform()
    autocheck = Autocheck()
    storage = YaMake2.StorageIntegrationParameters()
    debug = DebugParameters()
