# -*- coding: utf-8 -*-
from sandbox import sdk2


class CLANG_TIDY(sdk2.Resource):

    releasable = False
    auto_backup = True
    any_arch = False


class ContribBinary(sdk2.Resource):
    """Базовый класс для бинарных ресурсов."""

    releasable = True
    releasers = [
        "YATOOL",
        "robot-contrib",
    ]

    auto_backup = True
    any_arch = False
    executable = True


class Yamaker(ContribBinary):
    """Предсобранный yamaker."""


class YamakerReimportDiff(sdk2.Resource):
    """Ресурс с diff-ом, выявленном при реимпорте."""


class ContribUpdateApi(ContribBinary):
    """Сервис обновления контрибов (API)."""
