import six

from . import results_parser

from test.reports import console
from yalibrary import display
from yalibrary import formatter


def gen_html_from_results(results_filename):
    try:
        suites, error = results_parser.parse_from_file(results_filename), None
    except Exception as e:
        suites, error = [], e

    scheme = formatter.palette.LIGHT_HTML_SCHEME
    profile = {formatter.Highlight.PATH: formatter.Colors.BLUE}

    stream = six.StringIO()
    html_display = display.Display(
        stream, formatter.Formatter(formatter.HtmlSupport(scheme=scheme, profile=profile), show_status=False)
    )
    try:
        if error:
            html_display.emit_message("[[bad]]Failed to parse test results: {}".format(error))
        else:
            reporter = console.ConsoleReporter(
                show_passed=False,
                show_test_cwd=False,
                show_metrics=False,
                truncate=True,
                show_deselected=False,
                show_skipped=False,
                omitted_test_statuses=['good', 'xfail'],
                display=html_display,
            )

            for suite in suites:
                reporter.on_test_suite_finish(suite)
            reporter.on_tests_finish(suites)
    finally:
        html_display.close()
    return stream.getvalue()
