# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

import sys

import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts
import sandbox.projects.common.nanny.nanny as nanny

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sandboxsdk import svn
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.di.common.tasks import TemplateMixin
from sandbox.projects.di.resources import (
    DiBackendCelery,
    DiBackendManage,
    DiBackendUwsgi,
    DiJinjaRenderer,
    DiSoxVerifier,
    DiUnistat,
)
from sandbox.projects.di.settings import SANDBOX_VAULT

SECRET = "sec-01dp2a8zzst8fhjhnpz2f8jb86"

BINARIES = (
    DiBackendCelery,
    DiBackendManage,
    DiBackendUwsgi,
    DiJinjaRenderer,
    DiSoxVerifier,
    DiUnistat,
)


class BuildDiBinaries(TemplateMixin, YaMakeTemplate.YaMakeTemplate):
    """Сборка бинарников для Интерфейса Дистрибуции."""

    class Parameters(YaMakeTemplate.get_project_params(BINARIES)):

        with sdk2.parameters.Group("Nanny") as base:
            startrek_ticket_ids = nanny.StartrekTicketIdsParameter2(
                "Tracker Tickers IDs",
                description="Список тикетов в StartTrek в которые Няня оставит комментарии о состоянии релиза",
            )

        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.YMAKE_BUILD_SYSTEM)

    def _vault_client(self):
        sys.path.append(
            svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/library/python/vault_client/"),
        )
        from vault_client.instances import Production
        secret = yav.Secret(SANDBOX_VAULT).data()
        return Production(authorization=secret["VAULT_TOKEN"])

    def on_release(self, additional_parameters):
        if additional_parameters["release_status"] == "stable":
            checksums = {}
            for resource in BINARIES:
                meta_resource = resource.find(task=self).first()
                checksums[str(resource)] = meta_resource.md5
            vault_client = self._vault_client()
            vault_client.create_secret_version(SECRET, checksums, comment=additional_parameters["release_subject"])
        super(BuildDiBinaries, self).on_release(additional_parameters)
