# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

from sandbox.projects.trendbox_ci.beta.tasks.trendbox_ci_lxc import TrendboxCiLXC

CUSTOM_SCRIPT = """
export DEBIAN_FRONTEND=noninteractive

# Сделаем /bin/sh алиасом bash
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure dash

# For yarn
curl -sS https://dl.yarnpkg.com/debian/pubkey.gpg | apt-key add -
echo "deb https://dl.yarnpkg.com/debian/ stable main" | tee /etc/apt/sources.list.d/yarn.list

# For new libpq-dev
curl -sS https://www.postgresql.org/media/keys/ACCC4CF8.asc | apt-key add -
sh -c 'echo "deb http://apt.postgresql.org/pub/repos/apt $(lsb_release -cs)-pgdg main" > /etc/apt/sources.list.d/pgdg.list'

apt update --yes

apt install --yes \\
    python3 \\
    python3-pip \\
    default-jre \\
    libpq-dev \\
    postgresql \\
    yarn

# PyPI
tee /etc/pip.conf <<EOF
[global]
index-url = https://pypi.yandex-team.ru/simple
timeout = 120
EOF

pip3 install --upgrade pip

pip3 install --upgrade \\
    pytest \\
    requests \\
    xlrd \\
    "pyhamcrest<2" \\
    psycopg2 \\
    allure-pytest \\
    pytest-xdist

# Allure
ALLURE_VERSION=2.13.8
mkdir -p /opt
cd /opt
curl https://repo.maven.apache.org/maven2/io/qameta/allure/allure-commandline/${ALLURE_VERSION}/allure-commandline-${ALLURE_VERSION}.tgz -o allure-commandline.tgz
tar zxf allure-commandline.tgz
rm allure-commandline.tgz
ln -s /opt/allure-${ALLURE_VERSION}/bin/allure /usr/bin/allure
"""


class BuildDiCiContainer(TrendboxCiLXC):
    """Сборка контейера с окружением для CI."""

    class Parameters(TrendboxCiLXC.Parameters):
        kill_timeout = 30 * 60  # 30 min
        description = "DI LXC container for CI (Xenial)"

        components = TrendboxCiLXC.Parameters.components(default=("node_js",))
        ubuntu_release = TrendboxCiLXC.Parameters.ubuntu_release(default="xenial")
        custom_script = TrendboxCiLXC.Parameters.custom_script(default=CUSTOM_SCRIPT.strip())
