# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

import os
import tarfile

import sandbox.projects.common.nanny.nanny as nanny

from sandbox import sdk2

from sandbox.projects.di.common.tasks import TemplateMixin
from sandbox.projects.di.resources import (
    PydiConfigBundle,
    PydiConfigBundleBeta,
    PydiLoopConf,
    PydiLoopConfBeta,
)


class BuildDIConfigBundle(nanny.ReleaseToNannyTask2, TemplateMixin, sdk2.Task):
    """Собирает и релизит всяческую статику сервисов Интерфейса Дистибуции - конфиги, скрипты и пр."""

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Nanny") as base:
            startrek_ticket_ids = nanny.StartrekTicketIdsParameter2(
                "Tracker Tickers IDs",
                description="Список тикетов в StartTrek в которые Няня оставит комментарии о состоянии релиза",
            )

        build_beta_configs = sdk2.parameters.Bool(
            "Build configs for beta",
            required=True,
            default=True
        )
        arcadia_configs_path = sdk2.parameters.ArcadiaUrl(
            "Path to DI RTC configs",
            default_value="arcadia:/arc/trunk/arcadia/distribution_interface/configs/rtc_di",
            required=True
        )

    @property
    def configs_path(self):
        return str(self.path("configs_from_arcadia"))

    def copy_configs_from_arcadia(self):
        sdk2.svn.Arcadia.export(self.Parameters.arcadia_configs_path, self.configs_path)

    def build_configs(self):
        res_type = PydiConfigBundleBeta if self.Parameters.build_beta_configs else PydiConfigBundle
        self.path("configs").mkdir()
        res_type.pack_files(
            self.configs_path,
            str(self.path("configs"))
        )
        with tarfile.open(str(self.path("configs.tar")), "w") as tf:
            tf.add("configs/", recursive=True)

        sdk2.ResourceData(
            res_type(self, "DI configs bundle from {}".format(self.id), str(self.path("configs.tar")))
        ).ready()

    def build_single_file_resource(self, res_type, res_name):
        sdk2.ResourceData(res_type(
            self,
            "DI {} from {}".format(res_name, self.id),
            os.path.join(self.configs_path, res_type.file_name)
        )).ready()

    def on_execute(self):
        self.copy_configs_from_arcadia()
        self.build_configs()
        self.build_single_file_resource(
            res_type=PydiLoopConfBeta if self.Parameters.build_beta_configs else PydiLoopConf,
            res_name="instancectl",
        )
