# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.porto import BuildPortoLayer
from sandbox.projects.porto.common.resource_types import PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP

from sandbox.projects.di.resources import DiPortoLayer


class BuildDiPortoLayer(sdk2.Task):
    """Сборка порто-лейера сервисов Интерфейса Дистрибуции."""

    class Parameters(sdk2.Task.Parameters):
        description = "Build DI porto layer"

        script = sdk2.parameters.String(
            "Build script",
            default="arcadia:/arc/trunk/arcadia/distribution_interface/configs/rtc_di/porto/build_porto_layer.sh",
            required=True,
        )

    def build_layer(self):
        layer_build_params = {
            BuildPortoLayer.ParentLayerType.name: PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP.name,
            BuildPortoLayer.LayerType.name: DiPortoLayer.name,
            BuildPortoLayer.LayerName.name: "porto_pydi_layer",
            BuildPortoLayer.ScriptUrl.name: self.Parameters.script,
            BuildPortoLayer.Compress.name: "tar.zst",
            BuildPortoLayer.KeepResolvConf.name: True,
        }

        layer_build_task = sdk2.Task["BUILD_PORTO_LAYER"](
            self,
            description="DI porto layer",
            **layer_build_params
        ).enqueue()

        self.Context.build_layer_task_id = layer_build_task.id

        raise sdk2.WaitTask([layer_build_task], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def create_resource(self):
        layer_resource = sdk2.Resource.find(
            task_id=self.Context.build_layer_task_id,
            type=DiPortoLayer,
        ).first()
        layer_resource_data = sdk2.ResourceData(layer_resource)
        sdk2.paths.copy_path(str(layer_resource_data.path), layer_resource_data.path.name)

        new_layer_resource = DiPortoLayer(
            self,
            layer_resource.description,
            layer_resource_data.path.name,
        )
        sdk2.ResourceData(new_layer_resource).ready()

        new_layer_resource.ttl = 100
        for attr_name, attr_value in layer_resource:
            setattr(new_layer_resource, attr_name, attr_value)

        layer_resource.ttl = 1

    def on_execute(self):
        with self.memoize_stage.first_step:
            self.build_layer()

        with self.memoize_stage.second_step:
            self.create_resource()
