# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

import os

from sandbox import sdk2

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import svn

from sandbox.projects.di.resources import (
    DiBackendUwsgi,
    DiAllureReport,
)
from sandbox.projects.trendbox_ci.beta.resources import TRENDBOX_CI_LXC_IMAGE_BETA


class DiRegress(sdk2.Task):
    """Регресс Интерфейса Дистрибуции."""

    class Requirements(sdk2.Requirements):
        disk_space = 2 * 1024  # 2 Gb
        cores = 1

        container_resource = sdk2.parameters.Container(
            resource_type=TRENDBOX_CI_LXC_IMAGE_BETA,
            attrs={
                "owner": "DI",
            },
        )

    class Parameters(sdk2.Parameters):
        description = "Регресс Интерфейса Дистрибуции"

        prod_binary = sdk2.parameters.LastResource(
            "uWSGI binary (production)",
            required=True,
            resource_type=DiBackendUwsgi,
            owner="DI",
            attrs={"released": "stable"},
        )
        test_binary = sdk2.parameters.LastResource(
            "uWSGI binary (testing)",
            required=True,
            resource_type=DiBackendUwsgi,
            owner="DI",
            attrs={"released": "testing"},
        )

    def on_execute(self):
        tests = svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/distribution_interface/backend")

        os.environ["PRODUCTION_BINARY"] = str(self.Parameters.prod_binary.id)
        os.environ["TESTING_BINARY"] = str(self.Parameters.test_binary.id)

        report_data = sdk2.ResourceData(
            DiAllureReport(self, "Отчет об регрессе", "allure_html", ttl=30)
        )
        report_data.path.mkdir(0o755, parents=True, exist_ok=True)
        run_process(
            ["pytest", "-vv", "--alluredir=allure_raw", tests + "/regress"],
            log_prefix="regress",
            shell=True,
            check=False,
        )
        run_process(
            ["allure", "generate", "allure_raw", "-o", str(report_data.path)],
            log_prefix="allure",
            shell=True,
            check=False,
        )
        report_data.ready()
