# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, unicode_literals

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.environments import PipEnvironment

from sandbox.projects.di.resources import PydiTaxAuditDump
from sandbox.projects.di.settings import SANDBOX_VAULT

COMMAND = (
    "yt read-table "
    "--proxy {proxy} "
    "--format dsv "
    "--config \"{config}\" "
    "//home/distribution-archive/samples/{table} "
    " | "
    "gzip --best > tax_audit.gz"
)


class MakeTaxAuditDump(sdk2.Task):
    """Выгрузка для ФНС."""

    class Parameters(sdk2.Parameters):
        kill_timeout = 3 * 24 * 60 * 60  # 3 days

        with sdk2.parameters.Group("YT") as yt_block:
            yt_proxy = sdk2.parameters.String(
                "Proxy",
                default="hahn",
                required=True,
            )
            yt_table = sdk2.parameters.String(
                "Download table",
                default="",
                required=True,
            )
            yt_config = sdk2.parameters.String(
                "Config",
                default="{read_parallel={enable=%true;max_thread_count=50;}}",
                required=True,
            )

    class Requirements(sdk2.Requirements):
        disk_space = 2 * 1024 * 1024  # 2 Tb
        cores = 1

        environments = [
            PipEnvironment("yandex-yt"),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        secret = yav.Secret(SANDBOX_VAULT).data()

        run_process(
            [
                COMMAND.format(
                    proxy=self.Parameters.yt_proxy,
                    config=self.Parameters.yt_config,
                    table=self.Parameters.yt_table,
                )
            ],
            log_prefix="download",
            outputs_to_one_file=True,
            shell=True,
            environment={
                "YT_TOKEN": secret["YT_TOKEN"],
            },
        )

        resource = PydiTaxAuditDump(
            task=self,
            path="tax_audit.gz",
            description="Выгрузка для ФНС ({})".format(self.Parameters.yt_table),
            ttl=180,
        )
        sdk2.ResourceData(resource).ready()
