# -*- coding: utf-8 -*-

from sandbox import sdk2

import logging

log = logging.getLogger(__file__)


class FiveMinutesTask(sdk2.Task):
    class Context(sdk2.Task.Context):
        sleep_time = 30
        waitings = []

    @sdk2.header()
    def header(self):
        return "Waited: %s" % str(self.Context.waitings)

    def on_execute(self):

        if len(self.Context.waitings) < 10:
            self.Context.waitings.append(self.Context.sleep_time)
            self.Context.save()
            raise sdk2.WaitTime(self.Context.sleep_time)

        else:
            pass
