**BUILD_PORTO_LAYER_2** — основная задача для сборки LXC-контейнеров и Porto-слоев для использования в **New CI**, **Sandbox** и **Deploy**.
Это логическое развитие задачи **BUILD_PORTO_LAYER** портированной на Sandbox SDK2.

Цель работы этой задачи — получить Sandbox-ресурс, который можно будет использовать в качестве базовой операционной системы с окружением и установленными пакетами настроенными для выполнения различных задач: выполнение сборок и проверок в New CI, запуск cron-задач в Sandbox, запуск приложения развернутого в Deploy и других.

По сравнению с **BUILD_PORTO_LAYER** в задачу добавлена поддержка монтирования Arc для получения скриптов для подготовки контейнера (для простоты я буду объединять термины LXC-контейнеры и Porto-слои одним словом «контейнер», детали и различия в данном случае не так принципиальны), а так же реализована поддержка секретов из YAV для получения токена к Arc, но это можно достаточно легко расширить задачу для поддержки любых других секретов из YAV.

## Основная идея
![Блок-схема работы таски](https://wiki.yandex-team.ru/direct/devteam/buildportolayer2/.files/buildportolayer21.jpg)

Мы указываем, какую операционную систему и какой образ использовать как базовый, немного по разному, для сборки LXC-контейнера мы выбираем версию дистрибутива, а для Porto-слоя выбираем тип базового слоя и ID Sandbox-ресурса с ним, после этого задаем тип Sandbox-ресурса, который хотим получить на выходе, а так же указываем набор скриптов, которые будут по очереди выполнены в базовой системе и которые должны установить и настроить всё необходимое для сборки и работы приложения: Node.js, Python, Postgres-клиент, глобальные NPM-пакеты и т.д.

Эти скрипты должны быть написаны на BASH и будут выполнены из под пользователя `root`. В качестве источника для скриптов могут быть:
* подмонтированный Arc, путь до каждого скрипта в списке должен быть полным путем в Аркадии от корня, например: `adv/frontend/scripts/build_porto_layer.sh`
* файл экспортируемый из Аркадии из SVN, может указываться с ревизией или без, например: `arcadia:/arc/trunk/arcadia/adv/frontend/scripts/build_porto_layer.sh@r9254251`
* протокол HTTP(S), скрипт должен отдаваться как текст, это может быть текстовая версия кода на [Yandex Paste](https://paste.yandex-team.ru) или bash-файл в S3, например: `https://paste.yandex-team.ru/9416658/text`

## Советы и рекомендации
1. Если вы хотите использовать один и тот же контейнер и для сборки в New CI и для запуска приложения в Deploy, то вам в любом случае необходимо использовать Porto-слои, LXC-контейнеры не поддерживаются в Deploy.
2. По возможности используйте Porto-слои они меньше по размеру, для сравнения `app` Porto-слой [PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP](https://sandbox.yandex-team.ru/resource/3098078136) c Ubuntu Bionic весит **180Мб** и этого образа достаточно для базового образа с операционной системой, в то время как LXC-контейнер с той же Ubuntu Bionic весит **430Мб**.
3. Porto-слои позволяют более гибко организовать работу и разделить всё на отдельные независимые слои.
   Например, нам необходимо собрать Node.js приложение и раскатить его в Deploy.
   Слои для сборки приложения в New CI можно организовать следующим образом:
   1. `PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP` как базовый слой с операционной системой
   2. Слой с Node.js 16
   3. Слой с PNPM и другими установленными глобально зависимостями, необходимыми для сборки приложения
   4. Слой с Python 3.6 или 3.10+ собранным из Аркадии, необходим для сборки бинарных зависимостей для Node.js 16
   5. Слой с build-essential, необходим для сборки бинарных зависимостей

   Слои для запуска в Deploy можно организовать следующим образом:
   1. `PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP` как базовый слой с операционной системой
   2. Слой с Node.js 16
 
   Все остальные слои в runtime будут не нужны и все зависимости уже будут собраны под Node.js 16 и под Ubuntu Bionic.
   При этом вы будете иметь гарантированно одинаковое окружение в New CI и Deploy.

4. Разделяйте bash-скрипты для создания и настройки контейнеров на отдельные и независимые части, например: установка Python, установка Node.js, установка PNPM, установка build-essential.
   Так вам будет проще переиспользовать скрипты в разных проектах и изменения в каждом из них будут более атомарные.
5. Храните bash-скрипты в Аркадии, с возможностью монтирования Arc и возможностью переключения на любую ветку или коммит вы можете отлаживать скрипты до вливания и будет сохраняться история их изменения.
6. У вас нет возможности на этапе сборки контейнера объявить переменную окружения и передать её далее в скрипты запускаемые в этом контейнере в New CI или в Sandbox.
  Так же, если вы попробуете записать экспортирование необходимых вам переменных в системные файлы, такие как `/etc/environment` или `/etc/bash.bashrc` или `/etc/profile`, то это также не приведет к желаемому эффекту.
  Это связано с тем как Sandbox запускает LXC-контейнеры и как запускает процессы в них.
  Но вы можете при сборке контейнера создать файл (например: `/.env.sh`) записать в него все необходимые вам экспорты и уже в коде вашей джобы исполнить его командой [source](https://linuxize.com/post/bash-source-command/).
  **Важно:** не сохраняйте таким образом секреты. Ваш контейнер может быть использован любым сотрудником и таким образом ваши секреты могут быть дискредитированы.
  Если вам необходимо передать внутрь контейнера секрет всегда пользуйтесь для этого средствами New CI или задачи в Sandbox и выгружайте его при исполнении из YAV.

## Примеры удачных сборок
* https://sandbox.yandex-team.ru/task/1317902013/view
  Собирается LXC-контейнер на основе Ubuntu Bionic с Node.js 16 и всем необходимым для сборки и установки зависимостей. Скрипт для сборки берется из Arc-ветки. 
* https://sandbox.yandex-team.ru/task/1312992375/view
  Коллеги из финтеха подготаваливают свой Porto-слой для бекенда на основе Ubuntu Bionic от RTC. Скрипт для сборки берется из коммита в Arc.

Можете взять их за основу, склонировать и до настроить на вашу ветку или ваши коммиты
