# -*- coding: utf-8 -*-

import sandbox.sdk2 as sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class DirectLogviewerDeployPackage(sdk2.Resource):
    """DIRECT_LOGVIEWER_DEPLOY_PACKAGE -- Ресурс с слоем java-logviewer для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectChassisDeployPackage(sdk2.Resource):
    """DIRECT_CHASSIS_DEPLOY_PACKAGE -- Ресурс с слоем java-chassis для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectStepsDeployPackage(sdk2.Resource):
    """DIRECT_STEPS_DEPLOY_PACKAGE -- Ресурс с слоем steps для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectAlwDeployPackage(sdk2.Resource):
    """DIRECT_ALW_DEPLOY_PACKAGE -- Ресурс с слоем alw для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectCanvasDeployPackage(sdk2.Resource):
    """DIRECT_CANVAS_DEPLOY_PACKAGE -- Ресурс с слоем canvas для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectApi5DeployPackage(sdk2.Resource):
    """DIRECT_API5_DEPLOY_PACKAGE -- Ресурс с слоем java-API5 для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectIntapiDeployPackage(sdk2.Resource):
    """DIRECT_INTAPI_DEPLOY_PACKAGE -- Ресурс с слоем java-intapi для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectWebDeployPackage(sdk2.Resource):
    """DIRECT_WEB_DEPLOY_PACKAGE -- Ресурс с слоем java-web для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectOneshotDeployPackage(sdk2.Resource):
    """DIRECT_ONESHOT_DEPLOY_PACKAGE -- Ресурс с слоем java-oneshot для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectEssDeployPackage(sdk2.Resource):
    """DIRECT_ESS_DEPLOY_PACKAGE -- Ресурс с слоем java-ess для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectBinlogbrokerDeployPackage(sdk2.Resource):
    """DIRECT_BINLOGBROKER_DEPLOY_PACKAGE -- Ресурс с слоем java-binlogbroker для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectM2ytDeployPackage(sdk2.Resource):
    """DIRECT_M2YT_PACKAGE -- Ресурс с слоем java-M2YT для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectB2ytDeployPackage(sdk2.Resource):
    """DIRECT_B2YT_DEPLOY_PACKAGE -- Ресурс с слоем java-B2YT для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectJobsDeployPackage(sdk2.Resource):
    """DIRECT_JOBS_DEPLOY_PACKAGE -- Ресурс с слоем java-jobs для Y.Deploy"""

    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']


class DirectMmmDeployPackage(sdk2.Resource):
    """DIRECT_MMM_DEPLOY_PACKAGE -- Ресурс с слоем direct-mmm (MySQL Master Monitor) для Y.Deploy"""

    auto_backup = True
    releasable = True
    releasers = resource_releasers.direct_sre + ['ppc', 'robot-direct-newci', 'robot-direct-chassis']
