import logging
import requests

from sandbox import sdk2


# DIRECT_QA_TRIGGER_JENKINS_JOB
class DirectQaTriggerJenkinsJob(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        description = "Trigger build job in jenkins-direct.qart.yandex-team.ru"
        job = sdk2.parameters.String('Jenkins job name')
        revision = sdk2.parameters.Integer('Revision to build')
        token = sdk2.parameters.YavSecret(
            "robot-irt-jenkins token secret (key is 'robot-irt-jenkins')",
            default="sec-01ekz3ze8ffp6v6jff9jg085yc",
        )

    def on_execute(self):
        url = 'https://jenkins-direct.qart.yandex-team.ru/job/direct-build-projects/job/{}/buildWithParameters?REVISION={}'.format(
            self.Parameters.job, self.Parameters.revision
        )
        logging.info('Starting build with url: {}'.format(url))

        token = self.Parameters.token.data()['robot-irt-jenkins']
        response = requests.post(url, auth=('robot-irt-jenkinks', token))
        logging.info('Build response: {}'.format(response.json()))
