import json
import requests
import time

from sandbox.projects.common.build.YaPackage2 import YaPackage2


class DirectYaPackage(YaPackage2):
    YP_TOKEN_YAV_SECRET_ID = 'sec-01ekz3ze8ffp6v6jff9jg085yc'

    class Context(YaPackage2.Context):
        timestamp_start = None

    def on_execute(self):
        self.Context.timestamp_start = time.time()
        YaPackage2.on_execute(self)

    def on_success(self, prev_status):
        timestamp_start = self.Context.timestamp_start
        timestamp_finish = time.time()

        metric = {
            'name': 'sandbox.DIRECT_YA_PACKAGE.exec_time.sec',
            'value': timestamp_finish - timestamp_start,
            'context': {
                'package': self.Parameters.packages,
                'version': self.Parameters.custom_version,
                'author': self.author,
            },
        }

        requests.post(
            "https://intapi.direct.yandex.ru/metrics/add",
            json.dumps({'metrics': [metric]}),
            headers={
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
        )
