# -*- coding: utf-8 -*-

import logging
import os
import sandbox.projects.common.juggler.jclient as jclient
import sandbox.projects.direct.tanker_translations.tanker_helper as tanker_helper
import sandbox.sandboxsdk.errors as errors
import sandbox.sandboxsdk.svn as svn
import sandbox.sdk2 as sdk2

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


class DirectDownloadTankerTranslations(sdk2.Task):
    """Download direct translation from Tanker"""

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia url', default_value=svn.Arcadia.trunk_url(), required=True)

        script_path = sdk2.parameters.String('Path to script', default='direct/bin/tanker.sh', required=True)

        package_path = sdk2.parameters.String(
            'Package to build path', default='direct/apps/direct-tanker-tool', required=True
        )

        vault_user = sdk2.parameters.String('Vault User', default='DIRECT', required=True)

        tanker_token_vault_name = sdk2.parameters.String(
            'Tanker token vault name', default='TANKER_TRANSLATIONS_TOKEN', required=True
        )

        commit_message = sdk2.parameters.String(
            'Commit message',
            default='DIRECT-129075 Download and commit tanker translations with sandbox',
            required=True,
        )

        enable_juggler_monitoring = sdk2.parameters.Bool("Enable Juggler Monitoring", default=True, required=True)
        with enable_juggler_monitoring.value[True]:
            juggler_event_host = sdk2.parameters.String(
                "Juggler event host", default="direct.checks.dev", required=True
            )

            juggler_event_service = sdk2.parameters.String(
                "Juggler event service", default="sandbox.DirectDownloadTankerTranslations", required=True
            )

    def on_execute(self):

        arcadia_dir = tanker_helper.run_command(self, "sandbox_download")

        direct_path = os.path.join(arcadia_dir, "direct")

        try:
            svn.Arcadia.commit(direct_path, self.Parameters.commit_message, "zomb-sandbox-rw")
        except svn.SvnError as ex:
            logger.error(ex)
            raise errors.SandboxTaskFailureError('Failed to commit translations: {}'.format(ex))

        if self.Parameters.enable_juggler_monitoring:
            jclient.send_events_to_juggler(
                self.Parameters.juggler_event_host,
                self.Parameters.juggler_event_service,
                'OK',
                'Translations was downloaded',
            )
