# -*- coding: utf-8 -*-

import logging
import sandbox.projects.common.juggler.jclient as jclient
import sandbox.projects.direct.tanker_translations.tanker_helper as tanker_helper
import sandbox.sandboxsdk.svn as svn
import sandbox.sdk2 as sdk2

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


class DirectUploadTankerTranslations(sdk2.Task):
    """Upload direct translation to Tanker"""

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia url', default_value=svn.Arcadia.trunk_url(), required=True)

        script_path = sdk2.parameters.String('Path to script', default='direct/bin/tanker.sh', required=True)
        package_path = sdk2.parameters.String(
            'Package to build path', default='direct/apps/direct-tanker-tool', required=True
        )

        vault_user = sdk2.parameters.String('Vault User', default='DIRECT', required=True)

        tanker_token_vault_name = sdk2.parameters.String(
            'Tanker token vault name', default='TANKER_TRANSLATIONS_TOKEN', required=True
        )

        enable_juggler_monitoring = sdk2.parameters.Bool("Enable Juggler Monitoring", default=True, required=True)
        with enable_juggler_monitoring.value[True]:
            juggler_event_host = sdk2.parameters.String(
                "Juggler event host", default="direct.checks.dev", required=True
            )

            juggler_event_service = sdk2.parameters.String(
                "Juggler event service", default="sandbox.DirectUploadTankerTranslations", required=True
            )

    def on_execute(self):
        tanker_helper.run_command(self, "sandbox_upload")

        if self.Parameters.enable_juggler_monitoring:
            jclient.send_events_to_juggler(
                self.Parameters.juggler_event_host,
                self.Parameters.juggler_event_service,
                'OK',
                'Translations was uploaded',
            )
