# -*- coding: utf-8 -*-

import os
import sandbox.projects.common.arcadia.sdk as arcadia_sdk
import sandbox.projects.common.constants as consts
import sandbox.sandboxsdk.errors as errors
import sandbox.sandboxsdk.process as process
import sandbox.sdk2 as sdk2


def run_command(self, tanker_command):
    build_target = os.path.dirname(self.Parameters.package_path)

    arcadia_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(self.Parameters.arcadia_url)

    # change YMAKE_BUILD_SYSTEM to YA_MAKE_FORCE_BUILD_SYSTEM in https://st.yandex-team.ru/DIRECT-87618

    arcadia_sdk.do_build(
        consts.YA_MAKE_FORCE_BUILD_SYSTEM, arcadia_dir, [build_target], clear_build=False, results_dir=arcadia_dir
    )

    ya_path = os.path.join(arcadia_dir, 'ya')
    tanker_token = sdk2.Vault.data(self.Parameters.vault_user, self.Parameters.tanker_token_vault_name)

    cmd = [os.path.join(arcadia_dir, self.Parameters.script_path), tanker_command, ya_path, "-t", tanker_token]

    os_process = process.run_process(
        cmd, log_prefix='translations', outputs_to_one_file=False, shell=True, work_dir=arcadia_dir
    )

    if not os_process or os_process.returncode:
        raise errors.SandboxTaskFailureError('Process %s died' % cmd)

    return arcadia_dir
