# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import os

from sandbox.projects.direct_internal_analytics.laborer_base.exceptions import ExecutorNotFoundException
from sandbox.projects.direct_internal_analytics.laborer_base.imports import get_all_importable_objects
from .base import BaseExecutor
from ..target_types.base import BaseTarget

__all__ = ['get_executor']


class ExecutorsRegistry(object):
    def __init__(self):
        self._target_executors = {}

    def add_executor_class(self, executor):
        assert issubclass(executor, BaseExecutor)
        if executor.target_class is None:
            return
        assert issubclass(executor.target_class, BaseTarget)

        self._target_executors[executor.target_class] = executor

    def get_executor(self, target):
        for base_target in self._target_executors:
            if issubclass(target, base_target):
                return self._target_executors.get(base_target)


def get_executors_registry():
    ef = ExecutorsRegistry()

    base_path = os.path.normpath(os.path.dirname(os.path.realpath(__file__)))
    for obj in get_all_importable_objects(base_path, __name__, superclass=BaseExecutor):
        ef.add_executor_class(obj)
    return ef


def get_executor(target, config, context, force):
    """Получить объект класса, способный обработать переданную цель с заданными параметрами или выбросить исключение,
    если такого класса не существует
    """
    exec_class = get_executors_registry().get_executor(target)
    if exec_class is None:
        raise ExecutorNotFoundException()
    return exec_class(target, config, context, force)
