# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import logging

from datetime import datetime
from datetime import timedelta


from sandbox.projects.direct_internal_analytics.laborer_base.exceptions import ExecutionException
from .base import BaseExecutor
from ..target_types.close_tables import CloseTableTarget

logger = logging.getLogger(__name__)


class CloseTableExecutor(BaseExecutor):
    target_class = CloseTableTarget

    def execute(self, transaction_id=None):
        logger.info('Executing ct %s', self.title)

        date = datetime.strptime(self._context['date'].date().isoformat(), "%Y-%m-%d")

        date = date + timedelta(days=self.starttime_shift)

        logger.info('Start serch for tameplate:%s from %s', self.template, date)

        try_count = 0

        is_ok = False

        while (try_count < self.step_count):

            logger.info("Try date:%s", date)

            table_name = self.template.format(date=date)
            query_text = "select 1 from `{table_name}` limit 1".format(table_name=table_name)

            logger.info("Query:%s", query_text)

            query = self.yql.query(query_text, syntax_version=1)
            query.run()

            result = query.get_results()

            if result.is_success:
                is_ok = True
#                self._context['output_path'] = table_name
                self.yt.copy(table_name, self.output_path, recursive=True)
                logger.info("Found date:%s", date)
                break

            date = date + timedelta(days=self.time_step)
            try_count += 1

        if not is_ok:
            raise ExecutionException("Good date not found")

    @property
    def template(self):
        return self._target.template

    @property
    def starttime_shift(self):
        return self._target.starttime_shift

    @property
    def time_step(self):
        return self._target.time_step

    @property
    def step_count(self):
        return self._target.step_count

    @property
    def yql(self):
        return self._config['yql_client']
