# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import logging

from copy import deepcopy

from .base import BaseExecutor
from ..target_types.code import ExecuteWithYtTarget

logger = logging.getLogger(__name__)


class CodeWithYtExecutor(BaseExecutor):
    target_class = ExecuteWithYtTarget

    def execute(self, transaction_id=None):
        logger.info("Starting callable execution")
        context = self._context
        context['appsflyer_api_token'] = self._config['appsflyer_api_token']
        result = self.callable(self._context.get('dependencies', []), self.yt, deepcopy(context))
        self.yt_write_table(self.output_path, result)

    @property
    def callable(self):
        # noinspection PyUnresolvedReferences
        return self._target.execute
