# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import logging
from copy import deepcopy

import requests
from requests.status_codes import codes

from sandbox.projects.direct_internal_analytics.laborer_base.exceptions import ExecutionException
from .base import BaseExecutor
from ..target_types.http import GetHttpJsonDataTarget

logger = logging.getLogger(__name__)


class GetHttpJsonDataExecutor(BaseExecutor):
    target_class = GetHttpJsonDataTarget

    def execute(self, transaction_id=None):
        url = self.apply_template(self._target.url)
        logger.info("Requesting %s", url)
        if self._config['appsflyer_api_token'] is not None:
            response = requests.get(url, headers={"Authorization": self._config['appsflyer_api_token']}, verify=False)
        else:
            response = requests.get(url, verify=False)
        if response.status_code != codes.ok:
            raise ExecutionException("Invalid response code ({}) for url {}".format(response.status_code, url))

        base_data = response.json()
        items = self._target.get_items(base_data)

        logger.info("Converting data")
        local_context = deepcopy(self._context)
        data_to_insert = []
        for item in items:
            if not self._target.should_process(item, local_context):
                continue

            row = {}
            for field, converter in self._target.fields:
                row[field] = converter(item)
            data_to_insert.append(row)

        self.yt_write_table(self.output_path, data_to_insert)
