# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import logging
import os.path
import subprocess
import tempfile

from sandbox.projects.direct_internal_analytics.laborer_base.imports import content_path
from .base import BaseExecutor
from ..target_types.ytpump import YtPumpTarget

LOGGER = logging.getLogger(__name__)


class YtPumpExecutor(BaseExecutor):
    target_class = YtPumpTarget

    def execute(self, transaction_id=None):
        with tempfile.NamedTemporaryFile() as tvm_secret_file:
            tvm_secret_file.file.write(self._config['tvm_secret'])
            tvm_secret_file.flush()

            target_path = self._context.get('unpacked_target_path', content_path)
            ytpump_path = os.path.join(target_path, self._target.ytpump_binary)
            cmd_template = [
                ytpump_path,
                '--cluster', self._context['yt_cluster'],
                '--input', self._target.input_table,
                '--session-by', self._target.session_by_column,
                '--group-by', self._target.group_by_column,
                '--ignore-fields', ','.join(self._target.ignore_fields),
                '--logbroker', self._target.lb_endpoint,
                '--topic', self._target.lb_topic,
                '--format', self._target.format_,
                '--json-validate-utf8', self._target.json_validate_utf8,
                '--chunk-size', str(self._target.chunk_size),
                '--tvm-src-id', self._config['tvm_id'],
                '--tvm-dst-id', self._target.tvm_dst_id,
                '--tvm-secret', tvm_secret_file.name,
                '--do-write', '1',
            ]
            cmd = [self.apply_template(arg) for arg in cmd_template]
            env = {
                'YT_TOKEN': self.yt.config['token'],
                'YT_LOG_LEVEL': 'INFO',
            }
            LOGGER.info('Running command %r', ' '.join(cmd))
            subprocess.check_call(cmd, env=env, stderr=subprocess.STDOUT)
            self.yt_write_table(self.output_path)
            LOGGER.info('Finish sending table %r to LogBroker', self._target.input_table)
