# coding=utf-8
"""
Модуль, содержащий базовые классы для описания целей, выполняющих вычисления с помощью выполнения произвольного кода
"""
from __future__ import absolute_import, unicode_literals, print_function

from .base import BaseTarget


class ExecuteWithYtTarget(BaseTarget):
    """Исполняемый код """
    _namespace = 'exec_'
    execute_in_transaction = False

    @classmethod
    def execute(cls, dependencies_path, yt_client, context):
        """Получить одномерный список из элементов для загрузки

        :param dependencies_path: пути к зависимостям в порядке их перечисления
        :type dependencies_path: list[basestring]
        :param yt_client: настроенный инстанс YT-клиент
        :type yt_client: yt.wrapper
        :param context: контекст выполнения
        :type context: dict[basestring]

        :returns: список словарей с ключами-строками, который будет загружен в
        :rtype: collections.Iterable[dict[str]]
        """
        raise NotImplementedError()
