# coding=utf-8
"""
Модуль, содержащий базовые классы для описания целей, работающих с данными, получаемыми по HTTP
"""
from __future__ import absolute_import, unicode_literals, print_function

from .base import BaseTarget


class GetHttpJsonDataTarget(BaseTarget):
    """Читающий запрос в Json-ручку. Парсит ответ и складывает его в таблицу"""
    _namespace = 'http_'

    # HTTP-адрес ручки
    # Для использования в теле запроса доступно несколько плейсхолдеров:
    # - {date} - дата, за которую делается отчет. Можно использовать в синтаксисе .format, например как {date:%Y%m} для
    #            получения только года и месяца
    url = None

    # Список пар <название поля> - <код его получения> (см. пример в описании таргета FetchReleases)
    fields = None

    @classmethod
    def get_items(cls, data):
        """Получить одномерный список из элементов для загрузки

        :param data: полные данные из ручки (уже в виде объектов python)
        """
        raise NotImplementedError()

    @classmethod
    def should_process(cls, item, context):
        """Вернуть False, если объект нужно пропустить

        :param item: Объект из ответа ручки (список этих обхектов отдает get_items)
        :param context: контекст исполнения (в нем, например, есть ключ date с датой)
        """
        return True
