# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import re
from datetime import timedelta

from jinja2 import Environment

__all__ = ['smart_apply_template']

JINJA_PATTERN = re.compile(r'{{.*?}}|{%.*?%}|{#.*?#}')
FORMAT_PATTERN = re.compile(r'{.*?}')

_jinja_env = None


def _get_env():
    global _jinja_env
    if _jinja_env is None:
        _jinja_env = Environment()
        _jinja_env.filters['minus_days'] = _sub_days
        _jinja_env.filters['minus_hours'] = _sub_hours
        _jinja_env.filters['format_date'] = _format_date

    return _jinja_env


def _sub_days(value, days):
    return value - timedelta(days=days)


def _sub_hours(value, hours):
    return value - timedelta(hours=hours)


def _format_date(value, pattern):
    pattern = '{:' + pattern + '}'
    return pattern.format(value)


def _jinja_apply_template(template_str, context):
    template = _get_env().from_string(template_str)
    return template.render(**context)


def _format_apply_template(template, context):
    return template.format(**context)


def smart_apply_template(template, context):
    if JINJA_PATTERN.search(template):
        return _jinja_apply_template(template, context)
    elif FORMAT_PATTERN.search(template):
        return _format_apply_template(template, context)
    else:
        return template
