# coding=utf-8
"""
Сборка кубов для комерческого департамента
"""
from __future__ import absolute_import, unicode_literals, print_function

from sandbox.projects.direct_internal_analytics.laborer.target_types.base import YqlSelectTarget


class TmpYqlSelectTarget(YqlSelectTarget):
    final = True

    target_template_path = "{home}/{token}/tmp/{_title}/{date:%Y-%m-%d}"

    expiration_days = 14


class GroupToApp(TmpYqlSelectTarget):
    title = 'group_to_app'

    query = """
        insert into [{insert_target}]
        select
            p.pid as GroupExportID,
            if(m.os_type = 'iOS', m.bundle_id, m.store_content_id) as AppID
        from
            [//home/direct/db/phrases] as p
        left join
            [//home/direct/db/mobile_content] as m on m.mobile_content_id = p.mobile_content_id
        where
            m.store_content_id is not null
    """


class JoinedChEvent(TmpYqlSelectTarget):
    title = "joined_ch_event"

    query = """
        $last_date = '{{date|format_date('%Y-%m-%d')}}';
        $first_date = '{{date|minus_days(10)|format_date('%Y-%m-%d')}}';
        SELECT 1 FROM RANGE([//home/logfeller/logs/bs-chevent-log/1d], $last_date, $last_date) LIMIT 1;

        $mask = (select
            sum(cast(1 as UInt64) << COALESCE(cast(-1 * cast(GoodEvent as Int32) as UInt8), 0))
        from
            [//home/yabs/dict/GoodEvent]
        where
            IsGoodInstall = 1
        );

        insert into [{{insert_target}}]
        select
            l.age as  Age,
            l.bannerid as  BannerID,
            l.browsername as BrowserName,
            l.cryptaid as CryptaID,
            l.hitdevicetype as HitDeviceType,
            l.dealexportid as  DealExportID,
            l.eventcost as EventCost,
            l.resourcepart as ResourcePart,
            l.contexttype as  ContextType,
            l.creativeid as  CreativeID,
            l.detaileddevicetype as  DetailedDeviceType,
            l.devicetype as  DeviceType,
            l.domainid as  DomainID,
            l.experimentbits as  ExperimentBits,
            cast(l.eventtime as Int64) as EventTime,
            l.gender as  Gender,
            l.groupbannerid as  GroupBannerID,
            l.groupexportid as  GroupExportID,
            l.height as  Height,
            l.logid as  LogID,
            l.options as  Options,
            l.orderid as  OrderID,
            l.pageid as  PageID,
            l.pageno as  PageNO,
            l.parentbannerid as  ParentBannerID,
            l.parentexportid as  ParentExportID,
            l.phraseexportid as  PhraseExportID,
            l.phraseid as  PhraseID,
            l.placeid as  PlaceID,
            l.producttype as  ProductType,
            l.regionid as  RegionID,
            l.resourceno as  ResourceNo,
            l.searchquerymd5 as  SearchQueryMD5,
            l.selecttype as  SelectType,
            l.simdistance as  SimDistance,
            l.statisticregionid as  StatisticRegionID,
            l.targetphraseid as  TargetPhraseID,
            l.typeid as  TypeID,
            l.fraudbits as FraudBits,
            cast(l.uniqid as UInt64) as UniqID,
            l.width as  Width,
            g.AppID as app_id
       from
            RANGE([//home/logfeller/logs/bs-chevent-log/1d], $first_date, $last_date) as l
       inner join
            [{{dependencies[0]}}] as g on cast(l.groupexportid as Int64) = g.GroupExportID
       where
                cast(l.fraudbits as UInt64) | $mask = $mask
            AND
                l.countertype == '2'
    """

    dependencies = [GroupToApp]


class DataDistinct(TmpYqlSelectTarget):
    title = 'uniq_clicks'

    query = """
        insert into [{insert_target}]
        select distinct
            UniqID as uniqid,
            LogID as logid,
            EventTime as eventtime,
            app_id
        from
            [{dependencies[0]}]
    """

    dependencies = [JoinedChEvent]


class YUidsUnperfect(TmpYqlSelectTarget):
    title = 'yuids_unperfect'

    query = """
$is_yandexuid = @@
def is_yandexuid(uniqid):
    return len(str(uniqid)) >= 10 and str(uniqid)[-10] == "1"
@@;

$udf = (Python::is_yandexuid("(Uint64?)->Bool", $is_yandexuid));

        insert into [{insert_target}]
        select
            cast(uniqid AS String) as yuid,
            eventtime,
            logid,
            app_id
        from
            [{dependencies[0]}]
        where
            $udf(uniqid)
    """

    dependencies = [DataDistinct]


class YUids(TmpYqlSelectTarget):
    title = 'yuids'

    query = """
        insert into [{insert_target}]
        select distinct
            yuid,
            eventtime,
            logid,
            app_id
        from
            [{dependencies[0]}]
    """

    dependencies = [YUidsUnperfect]


class CryptaUnperfect(TmpYqlSelectTarget):
    title = 'crypta_unperfect'

    query = """
$is_yandexuid = @@
def is_yandexuid(uniqid):
    return len(str(uniqid)) >= 10 and str(uniqid)[-10] == "1"
@@;

$udf = (Python::is_yandexuid("(Uint64?)->Bool", $is_yandexuid));

        insert into [{insert_target}]
        select
            cast(uniqid AS String) as crypta_id,
            eventtime,
            logid,
            app_id
        from
            [{dependencies[0]}]
        where
            not $udf(uniqid)
    """

    dependencies = [DataDistinct]


class CryptaIDs(TmpYqlSelectTarget):
    title = 'cryptaids'

    query = """
        insert into [{insert_target}]
        select distinct
            crypta_id,
            eventtime,
            logid,
            app_id
        from
            [{dependencies[0]}]
    """

    dependencies = [CryptaUnperfect]


class DevCryptaID(TmpYqlSelectTarget):
    title = 'dev_cryptaid'

    query = """
        PRAGMA yt.InferSchema;

        insert into [{insert_target}]
        select
           t2.value as crypta_id,
           t2.key as devid,
           eventtime,
           logid,
           app_id
        from
           [{dependencies[0]}] as t1
        inner join
           [//home/crypta/production/state/iscrypta/mapping_deviceid_cid] AS t2 on t1.crypta_id == t2.value
    """

    dependencies = [CryptaIDs]


class DevYuids(TmpYqlSelectTarget):
    title = 'dev_yuids'

    query = """
        PRAGMA yt.InferSchema;

        insert into [{insert_target}]
        select
           t2.value as yuid,
           t2.key as devid,
           eventtime,
           logid,
           app_id
        from
           [{dependencies[0]}] as t1
        inner join
           [//home/crypta/production/state/iscrypta/mapping_deviceid_yuid] AS t2 on t1.yuid == t2.value
    """

    dependencies = [YUids]


class UnionDev(TmpYqlSelectTarget):
    title = 'union_dev'

    query = """
       insert into [{insert_target}]
       select
           devid,
           eventtime,
           logid,
           app_id
       from
           [{dependencies[0]}]
       union all
       select
           devid,
           eventtime,
           logid,
           app_id
       from
           [{dependencies[1]}]
    """

    dependencies = [DevCryptaID, DevYuids]


class MergedDevid(TmpYqlSelectTarget):
    title = 'Merged_devid'

    query = """
        insert into [{insert_target}]
        select distinct
            devid,
            eventtime,
            logid,
            app_id
        from
            [{dependencies[0]}]
    """

    dependencies = [UnionDev]


class DistinctMergetDevID(TmpYqlSelectTarget):
    title = 'distinct_merget_devid'

    query = """
        insert into [{insert_target}]
        select distinct
            devid
        from
           [{dependencies[0]}]
    """

    dependencies = [UnionDev]


class CryptaIdsWithoutDevid(TmpYqlSelectTarget):
    title = 'cryptaids_without_devid'

    query = """
        insert into [{insert_target}]
        select
           t1.crypta_id as uniqid
        from
           [{dependencies[0]}] as t1
        LEFT ONLY JOIN
           [{dependencies[1]}] as t2 using(crypta_id)
    """

    dependencies = [CryptaIDs, DevCryptaID]


class YUisdsWithoutDevids(TmpYqlSelectTarget):
    title = 'yuids_without_devid'

    query = """
        insert into [{insert_target}]
        SELECT
            t1.yuid as uniqid
        FROM
            [{dependencies[0]}] as t1
        LEFT ONLY JOIN
            [{dependencies[1]}] as t2 USING(yuid)
    """

    dependencies = [YUids, DevYuids]


class UniqIdsWithoutDevid(TmpYqlSelectTarget):
    title = 'uniqids_without_devid'

    query = """
         insert into [{insert_target}]
         SELECT
            uniqid
         FROM
            [{dependencies[0]}]
         UNION ALL
         SELECT
             uniqid
         FROM
            [{dependencies[1]}]
    """

    dependencies = [CryptaIdsWithoutDevid, YUisdsWithoutDevids]


class LogIDWithoutDev(TmpYqlSelectTarget):
    title = 'log_id_without_dev'

    query = """
       insert into [{insert_target}]
       select distinct
           t1.eventtime as eventtime,
           t1.logid as logid
       from
           [{dependencies[0]}] as t1
       inner join
           [{dependencies[1]}] as t2 on t1.uniqid == Cast(t2.uniqid AS Uint64)
    """

    dependencies = [DataDistinct, UniqIdsWithoutDevid]


class FromPostBack(TmpYqlSelectTarget):
    title = 'from_post_back'

    query = """
        $last_date = '{{date|format_date('%Y-%m-%d')}}';
        $first_date = '{{date|minus_days(10)|format_date('%Y-%m-%d')}}';
        SELECT 1 FROM RANGE([//logs/bs-postback-log/1d], $last_date, $last_date) LIMIT 1;

        insert into [{{insert_target}}]
        select
            logid,
            max(1) as without_dev,
            max(cast(t1.postbacktime as Int64) - t2.EventTime) as install_lag,
            max(0) as is_reinstall,
            max(t1.packagename) as AppID
        from
            RANGE([//logs/bs-postback-log/1d], $first_date, $last_date) as t1
        inner join
            [{{dependencies[0]}}] as t2 on t1.logid == CAST(t2.LogID AS String)
        group by
            cast(t1.logid as Uint64) as logid
    """

    dependencies = [JoinedChEvent]


class MDevids(TmpYqlSelectTarget):
    title = 'm_devids'

    query = """
        insert into [{insert_target}]
        select
            t1.eventtime as eventtime,
            t1.app_id as app_id,
            t1.logid as logid,
            t1.devid as devid,
            t2.mmetric_devid as mmetric_devid
        from
            [{dependencies[0]}] as t1
        inner join
            [//home/crypta/production/state/graph/dicts/devid_hash] as t2 ON t1.devid == t2.devid
    """

    dependencies = [MergedDevid]


class FromMobileInstall(TmpYqlSelectTarget):
    title = 'from_mobile_install'

    query = """

    $last_date = '{{date|format_date('%Y-%m-%d')}}';
    $first_date = '{{date|minus_days(10)|format_date('%Y-%m-%d')}}';
    SELECT 1 FROM RANGE([//home/logfeller/logs/metrika-mobile-install-private-log/1d], $last_date, $last_date) LIMIT 1;
    SELECT 1 FROM RANGE([//home/logfeller/logs/metrika-mobile-install-log/1d], $last_date, $last_date) LIMIT 1;

    insert into [{{insert_target}}]
        SELECT
            logid,
            min(0) as without_dev,
            min(CAST(DateTime::ToSeconds(DateTime::FromTimeZone(DateTime::FromString(t2.InstallationDateTime), "Europe/Moscow")) AS INT64) - t1.eventtime) AS install_lag,
            max(if(t2._other{"IsReinstallation"} == "0", 0, 1)) as is_reinstall,
            max(t2.AppID) as AppID
        FROM
            [{{dependencies[0]}}] as t1
        INNER JOIN
            RANGE([//home/logfeller/logs/metrika-mobile-install-private-log/1d], $first_date, $last_date) as t2 ON t1.mmetric_devid == t2.DeviceID and t1.app_id == t2.AppID
        left join
            [{{dependencies[1]}}] as t3 on t1.logid == cast(t3.logid as String)
        WHERE
            CAST(DateTime::ToSeconds(DateTime::FromTimeZone(DateTime::FromString(t2.InstallationDateTime), "Europe/Moscow")) AS INT64) - t1.eventtime > 0
        and
            t3.logid is null
        group by
            cast(t1.logid as Uint64) as  logid

    union all

        SELECT
            logid,
            min(0) as without_dev,
            min(CAST(DateTime::ToSeconds(DateTime::FromTimeZone(DateTime::FromString(t2.InstallationDateTime), "Europe/Moscow")) AS INT64) - t1.eventtime) AS install_lag,
            max(if(t2._other{"IsReinstallation"} == "0", 0, 1)) as is_reinstall,
            max(t2.AppID) as AppID
        FROM
            [{{dependencies[0]}}] as t1
        INNER JOIN
            RANGE([//home/logfeller/logs/metrika-mobile-install-log/1d],$first_date, $last_date) as t2  ON t1.mmetric_devid == t2.DeviceID and t1.app_id == t2.AppID
        left join
            [{{dependencies[1]}}] as t3 on t1.logid == cast(t3.logid as String)
        WHERE
            CAST(DateTime::ToSeconds(DateTime::FromTimeZone(DateTime::FromString(t2.InstallationDateTime), "Europe/Moscow")) AS INT64) - t1.eventtime > 0
        and
            t3.logid is null
        group by
            cast(t1.logid as Uint64) as  logid
    """

    dependencies = [MDevids, FromPostBack]


class PreFinal(TmpYqlSelectTarget):
    title = 'pre_final'

    query = """
        insert into [{insert_target}]
        select
            *
        from
           [{dependencies[0]}]
        union all
        select
            *
        from
           [{dependencies[1]}]
    """

    dependencies = [FromPostBack, FromMobileInstall]


class Daily(YqlSelectTarget):
    title = 'daily'

    final = True

    target_template_path = "{home}/{token}/{_title}/{date:%Y-%m-%d}"

    query = """
        $first_date = '{{date|minus_days(10)|format_date('%Y-%m-%d')}}';
        $last_date = '{{date|minus_days(1)|format_date('%Y-%m-%d')}}';

        insert into [{{insert_target}}]
        select
            t2.Age as Age,
            t2.BannerID as BannerID,
            t2.BrowserName as BrowserName,
            t2.CryptaID as CryptaID,
            t2.HitDeviceType as HitDeviceType,
            t2.DealExportID as DealExportID,
            t2.EventCost as EventCost,
            t2.ResourcePart as ResourcePart,
            t2.ContextType as ContextType,
            t2.CreativeID as CreativeID,
            t2.DetailedDeviceType as DetailedDeviceType,
            t2.DeviceType as DeviceType,
            t2.DomainID as DomainID,
            t2.ExperimentBits as ExperimentBits,
            t2.EventTime as EventTime,
            t2.Gender as Gender,
            t2.GroupBannerID as GroupBannerID,
            t2.GroupExportID as GroupExportID,
            t2.Height as Height,
            t2.LogID as LogID,
            t2.Options as Options,
            t2.OrderID as OrderID,
            t2.PageID as PageID,
            t2.PageNO as PageNO,
            t2.ParentBannerID as ParentBannerID,
            t2.ParentExportID as ParentExportID,
            t2.PhraseExportID as PhraseExportID,
            t2.PhraseID as PhraseID,
            t2.PlaceID as PlaceID,
            t2.ProductType as ProductType,
            t2.RegionID as RegionID,
            t2.ResourceNo as ResourceNo,
            t2.SearchQueryMD5 as SearchQueryMD5,
            t2.SelectType as SelectType,
            t2.SimDistance as SimDistance,
            t2.StatisticRegionID as StatisticRegionID,
            t2.TargetPhraseID as TargetPhraseID,
            t2.TypeID as TypeID,
            t2.UniqID as UniqID,
            t2.FraudBits as FraudBits,
            t2.Width as Width,
            t1.AppID as AppID,
            t1.without_dev as without_dev,
            t1.install_lag as install_lag,
            t1.is_reinstall as is_reinstall
        from
            [{{dependencies[0]}}] as t1
        inner join
            [{{dependencies[1]}}] as t2 on cast(t2.LogID as UInt64) = t1.logid
        inner join
            RANGE([//{{home}}/{{token}}/daily], $first_date, $last_date) as t3 on t1.logid == cast(t3.LogID as UInt64)
        where
            t3.LogID is null
    """

    dependencies = [PreFinal, JoinedChEvent]
