# coding=utf-8
"""
Сборка кубов для комерческого департамента
"""
from __future__ import absolute_import, unicode_literals, print_function

from sandbox.projects.direct_internal_analytics.laborer.target_types.base import YqlSelectTarget
from sandbox.projects.direct_internal_analytics.laborer.target_types.close_tables import CloseTableTarget


class CloseCommon(CloseTableTarget):
    starttime_shift = 1
    time_step = 1
    step_count = 10

    target_template_path = "{home}/{token}/tmp/{_title}/{date:%Y-%m-%d}"


class CubeCommonYqlSelectTarget(YqlSelectTarget):
    final = True

    target_template_path = "{home}/{token}/tmp/{_title}/{date:%Y-%m-%d}"


class CloseHierarchicalMultipliers(CloseCommon):
    title = 'close_hierarchical_multipliers'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/hierarchical_multipliers'


class MultipliersMobileCids(CubeCommonYqlSelectTarget):
    title = 'multipliers_mobile_cids'

    query = """
        insert into [{insert_target}] with truncate
        select
            cid,
            cast(multiplier_pct as Int64) as mult
        from
            [{dependencies[0]}]
        where
            pid IS NULL
        and
            type = 'mobile_multiplier'
        order by cid
    """

    dependencies = [CloseHierarchicalMultipliers]


class MultipliersMobilePids(CubeCommonYqlSelectTarget):
    title = 'multipliers_mobile_pids'

    query = """
        insert into [{insert_target}] with truncate
        select
            cid,
            pid,
            cast(multiplier_pct as Int64) as mult
        from
            [{dependencies[0]}]
        where
            pid IS NOT NULL
        and
            type = 'mobile_multiplier'
        order by cid, pid
    """

    dependencies = [CloseHierarchicalMultipliers]


def get_multipliers_demography_cids():
    query = ""

    for i in range(0, 10):

        sub_query = """
            select
                    cid,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/age')) as age,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/gender')) as gender,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/multiplier_pct')) as mult
            from
                    [{dependencies[0]}]
            where
                    pid IS NULL
            and
                    type = 'demography_multiplier'
            and
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]')) is null
            and
                    is_enabled = 1
        """ % (i, i, i, i)

        if i > 0:
            query += " union all "

        query += sub_query

    return """
        insert into [{insert_target}] with truncate
        select
                cid,
                age,
                gender,
                cast(mult as Int64) as mult
        from
                (
                %s
        )
        order by cid
    """ % (query)


class MultipliersDemographyCids(CubeCommonYqlSelectTarget):
    title = 'multipliers_demography_cids'

    query = get_multipliers_demography_cids()

    dependencies = [CloseHierarchicalMultipliers]


def get_multipliers_demography_pids():
    query = ""

    for i in range(0, 10):

        sub_query = """
            select
                    cid,
                    pid,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/age')) as age,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/gender')) as gender,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/multiplier_pct')) as mult
            from
                    [{dependencies[0]}]
            where
                    pid IS NOT NULL
            and
                    type = 'demography_multiplier'
            and
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]')) is null
            and
                    is_enabled = 1
        """ % (i, i, i, i)

        if i > 0:
            query += " union all "

        query += sub_query

    return """
        insert into [{insert_target}] with truncate
        select
                cid,
                pid,
                age,
                gender,
                cast(mult as Int64) as mult
        from
                (
                %s
        )
        order by cid,pid
    """ % (query)


class MultipliersDemographyPids(CubeCommonYqlSelectTarget):
    title = 'multipliers_demography_pids'

    query = get_multipliers_demography_pids()

    dependencies = [CloseHierarchicalMultipliers]


def get_multipliers_retargeting_cids():
    query = ""

    for i in range(0, 100):

        sub_query = """
            select
                    cid,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/ret_cond_id')) as ret_cond_id,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/multiplier_pct')) as mult
            from
                    [{dependencies[0]}]
            where
                    pid IS NULL
            and
                    type = 'retargeting_multiplier'
            and
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]')) is null
            and
                    is_enabled = 1
        """ % (i, i, i)

        if i > 0:
            query += " union all "

        query += sub_query

    return """
        insert into [{insert_target}] with truncate
        select
                cid,
                ret_cond_id,
                cast(mult as Int64) as mult
        from
                (
                %s
        )
        order by cid
    """ % (query)


class MultipliersRetargetingCids(CubeCommonYqlSelectTarget):
    title = 'multipliers_retargeting_cids'

    query = get_multipliers_retargeting_cids()

    dependencies = [CloseHierarchicalMultipliers]


def get_multipliers_retargeting_pids():
    query = ""

    for i in range(0, 100):

        sub_query = """
            select
                    cid,
                    pid,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/ret_cond_id')) as ret_cond_id,
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]/multiplier_pct')) as mult
            from
                    [{dependencies[0]}]
            where
                    pid IS NOT NULL
            and
                    type = 'retargeting_multiplier'
            and
                    ListMax(Json::GetField(Yson::SerializeJson(values), '[%d]')) is null
            and
                    is_enabled = 1
        """ % (i, i, i)

        if i > 0:
            query += " union all "

        query += sub_query

    return """
        insert into [{insert_target}] with truncate
        select
                cid,
                pid,
                ret_cond_id,
                cast(mult as Int64) as mult
        from
                (
                %s
        )
        order by cid,pid
    """ % (query)


class MultipliersRetargetingPids(CubeCommonYqlSelectTarget):
    title = 'multipliers_retargeting_pids'

    query = get_multipliers_retargeting_pids()

    dependencies = [CloseHierarchicalMultipliers]


class CloseBidsRetargeting(CloseCommon):
    title = 'close_bids_retargeting'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/bids_retargeting'


class RetargetingGoals(CubeCommonYqlSelectTarget):
    title = 'retargeting_goals'

    query = """
    $script = @@
import json

def decode_goal_type(goal_id):
    if 1 <= goal_id and goal_id < 1 * pow(10,9):
        return 'metrika-goal'
    elif 1 * pow(10,9) <= goal_id and goal_id < 2 * pow(10,9):
        return 'metrika-segment'
    elif 2 * pow(10,9) <= goal_id and goal_id < 3 * pow(10,9):
        return 'audience-segment'
    elif 3 * pow(10,9) <= goal_id and goal_id < 3.9 * pow(10,9):
        return 'metrika-ecommerce'
    elif 3.9 * pow(10,9) <= goal_id and goal_id < 4 * pow(10,9):
        return 'scenarios-targets'
    elif 4 * pow(10,9) <= goal_id and goal_id < 4.1 * pow(10,9):
        return 'metrika-counter'
    else:
        return 'other'

def decode_goal_id(goal_id):
    if 1 <= goal_id and goal_id < 1 * pow(10,9):
        return goal_id
    elif 1 * pow(10,9) <= goal_id and goal_id < 2 * pow(10,9):
        return goal_id
    elif 2 * pow(10,9) <= goal_id and goal_id < 3 * pow(10,9):
        return goal_id - int(2 * pow(10,9))
    elif 3 * pow(10,9) <= goal_id and goal_id < 3.9 * pow(10,9):
        return goal_id - int(3 * pow(10,9))
    elif 3.9 * pow(10,9) <= goal_id and goal_id < 4 * pow(10,9):
        return goal_id - int(3.9 * pow(10,9))
    elif 4 * pow(10,9) <= goal_id and goal_id < 4.1 * pow(10,9):
        return goal_id - int(4 * pow(10,9))
    else:
        return goal_id

def parse(r):
    r = json.loads(r)
    for q in r:
        for g in q['goals']:
            goal_id = g['goal_id']
            yield goal_id
@@;

        $udf_parse = Python::parse("(String?)->List<Int64>", $script);
        $udf_goal_to_type = Python::decode_goal_type('(Int64)->String', $script);
        $udf_goal_to_id = Python::decode_goal_id('(Int64)->Int64', $script);

        insert into [{insert_target}] with truncate
        SELECT
                cid,
                pid,
                old_goal as goal_id,
                $udf_goal_to_id(old_goal) as real_id,
                $udf_goal_to_type(old_goal) as goal_type,
                price_context,
                price_context_rub
        from
        (
                SELECT
                    cid,
                    pid,
                    ret_id,
                    price_context,
                    price_context_rub,
                    old_goal
                from (
                        SELECT
                            cid,
                            pid,
                            ret_id,
                            price_context,
                            price_context_rub,
                            $udf_parse(Yson::SerializeJson(COALESCE(condition_json,'[]'))) as old_goals
                        from
                            [{dependencies[0]}]
                )
                flatten by old_goals as old_goal
        )
        order by cid, pid
    """

    dependencies = [CloseBidsRetargeting]


class CloseCampaigns(CloseCommon):
    title = 'close_campaigns'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/campaigns'


class Campaigns(CubeCommonYqlSelectTarget):
    title = 'campaigns'

    query = """
        $has_good_domain = Python::has_good_domain("(List<String?>)->Bool", @@
good_domains = ['auto.ru','avito.app','avito.ru','gismeteo.ru','kinopoisk.ru','mail.ru','mamba.ru','ok.ru','rambler.ru','vk.com','yandex.ru']
def has_good_domain(domain_list):
    for domain in domain_list:
        for good in good_domains:
            if domain == good or domain.endswith('.' + good):
                return True
    return False
@@);

            $mobile_multipliers = (
                select
                    cid,
                    count(*) as mob_multipliers,
                    count_if(mult > 100) as mob_multipliers_inc,
                    count_if(mult < 100) as mob_multipliers_dec
                from [{dependencies[0]}]
                group by cid
                order by cid
            );

            $demography_multipliers = (
                select
                    cid,
                    count(*) as dem_multipliers,
                    count_if(mult > 100) as dem_multipliers_inc,
                    count_if(mult < 100) as dem_multipliers_dec,
                    count_if(age is not null) as age_multipliers,
                    count_if(age is not null and mult > 100) as age_multipliers_inc,
                    count_if(age is not null and mult < 100) as age_multipliers_dec,
                    count_if(gender is not null) as gender_multipliers,
                    count_if(gender is not null and mult > 100) as gender_multipliers_inc,
                    count_if(gender is not null and mult < 100) as gender_multipliers_dec,
                    count_if(age is not null and gender is not null) as age_gender_multipliers,
                    count_if(age is not null and gender is not null and mult > 100) as age_gender_multipliers_inc,
                    count_if(age is not null and gender is not null and mult < 100) as age_gender_multipliers_dec
                from [{dependencies[1]}]
                group by cid
                order by cid
            );

            $retargeting_multipliers = (
                select
                    cid,
                    count(*) as ret_multipliers,
                    count_if(mult > 100) as ret_multipliers_inc,
                    count_if(mult < 100) as ret_multipliers_dec
                from [{dependencies[2]}]
                group by cid
                order by cid
            );

            $autobudget_goal_id = cast(Yson::LookupString(strategy_params, 'goal_id') as Int64);
            $autobudget_reserve_return = Yson::LookupDouble(strategy_params, 'reserve_return');
            $autobudget_profitability = Yson::LookupDouble(strategy_params, 'profitability');
            $campaigns = (
                select
                      cid
                    , uid
                    , cast(OrderID as UInt32) as order_id
                    , cast(ClientID as UInt32) as client_id
                    , cast(brand_ClientID as UInt32) as brand_client_id
                    , ManagerUID as manager_uid
                    , AgencyUID as agency_uid
                    , case when AgencyID = 0 then cast(NULL as Int64) else AgencyID end as agency_id
                    , if(wallet_cid > 0, wallet_cid) as wallet_cid
                    , type
                    , name
                    , currency
                    , platform = "search" as dont_show_yacontext
                    , case when lastShowTime = '0000-00-00 00:00:00' then cast(NULL as string) else lastShowTime end as last_show_time
                    , archived = "Yes" as status_archived
                    , statusShow = "Yes" as status_show
                    , statusActive = "Yes" as status_active
                    , statusModerate as status_moderate
                    , statusPostModerate as status_post_moderate
                    , statusOpenStat = "Yes" as status_open_stat
                    , statusBehavior = "Yes" as status_behavior
                    , statusMetricaControl = "Yes" as status_metrica_control
                    , status_click_track = 1 as status_click_track
                    , paid_by_certificate = "Yes" as paid_by_certificate
                    , enabled_sms = "Yes" as enabled_sms
                    , autobudget = "Yes" as autobudget
                    , strategy_name
                    , Yson::LookupDouble(strategy_params, 'sum') as autobudget_sum
                    , Yson::LookupDouble(strategy_params, 'bid') as autobudget_bid
                    , Yson::LookupInt64(strategy_params, 'limit_clicks') as autobudget_limit_clicks
                    , Yson::LookupDouble(strategy_params, 'avg_bid') as autobudget_avg_bid
                    , Yson::LookupDouble(strategy_params, 'avg_cpa') as autobudget_avg_cpa
                    , Yson::LookupDouble(strategy_params, 'avg_cpi') as autobudget_avg_cpi
                    , Yson::LookupDouble(strategy_params, 'filter_avg_bid') as autobudget_filter_avg_bid
                    , Yson::LookupDouble(strategy_params, 'filter_avg_cpa') as autobudget_filter_avg_cpa
                    , $autobudget_goal_id as autobudget_goal_id
                    , Yson::LookupDouble(strategy_params, 'roi_coef') as autobudget_roi_coef
                    , if(
                        $autobudget_reserve_return > 0 or $autobudget_profitability > 0,
                        AsTuple($autobudget_reserve_return, $autobudget_profitability),
                        null
                      ) as autobudget_roi_params
                    , ContextLimit as context_limit
                    , broad_match_flag = "Yes" as broad_match_flag
                    , broad_match_limit as broad_match_limit
                    , platform = "context" as is_search_stop
                    , cast(day_budget as double) as day_budget
                    , day_budget_show_mode as day_budget_show_mode
                    , autoOptimization = "Yes" as auto_optimization
                    , if(coalesce(wallet_autopay_mode, "none") = "none", cast(NULL as String), wallet_autopay_mode) as wallet_autopay_mode
                    , offlineStatNotice as offline_stat_notice
                    , email_notifications as email_notifications
                    , timeTarget as time_target
                    , timezone_id as timezone_id
                    , ContextPriceCoef as context_price_coef
                    , if(strategy != "", strategy) as strategy
                    , if(strategy_name = "no_premium", Yson::LookupString(strategy_params, 'place')) as strategy_no_premium  -- 'highest_place' уж не имеет смысла, можно эту логику удалять
                    , minus_words as minus_words
                    , ListFlatMap(ListFlatMap(String::SplitToList(metrika_counters, ','), "FromString", AsAtom("Int64")), "Coalesce") as metrika_counters
                    , ListFlatMap(ListFlatMap(String::SplitToList(geo, ','), "FromString", AsAtom("Int64")), "Coalesce") as geo
                    , ListSort(ListMap(ListMap(ListMap(ListMap(
                              String::SplitToList(DontShow, ','),
                          String::Strip), Url::ForcePunycodeToHostName), Url::GetHostPort), Url::CutWWW)
                      ) as dont_show
                from [{dependencies[3]}] as c
                where c.ClientID > 0 and c.uid > 0 and c.cid > 0
                order by cid
            );

            $is_search_enabled   = not is_search_stop and type != 'performance';
            $is_context_enabled  = not (nvl(context_limit, 0) = 254 or dont_show_yacontext);
            $is_different_places = if(autobudget = false and $is_context_enabled  = true, coalesce(strategy, '') = 'different_places');
            $context_limit       = if(autobudget = false and $is_different_places = false, context_limit);
            $context_price_coef  = if(autobudget = false and $is_different_places = false, context_price_coef);

            $is_auto      = autobudget;
            $is_min_price = if(autobudget = false and $is_search_enabled = true, false); -- option was removed
            $is_max_pos   = if(autobudget = false and $is_search_enabled = true, nvl(strategy_no_premium, 'highest_place') = 'highest_place'); -- 'highest_place' уже не имеет смысла, можно эту логику удалять
            $is_premium   = if(autobudget = false and $is_search_enabled = true, strategy_no_premium is null);
            $is_guarantee = if(autobudget = false and $is_search_enabled = true, true); -- option was removed
            $is_premium_only = $is_premium and not $is_guarantee;
            $is_guarantee_only = $is_guarantee and not $is_premium;

            $context_budget_type  = if($is_search_enabled = false, 'network', if($is_context_enabled = false, 'search', 'mixed'));
            $context_budget_share = if($is_search_enabled = false, 100, if($is_context_enabled = false, 0, if($context_limit > 0 and $context_limit <= 100, $context_limit)));

            $autobudget_amount = if(autobudget_sum > 0, autobudget_sum);

            $has_day_budget = if(autobudget = false, day_budget > 0);
            $is_day_budget_stretched = if(autobudget = false, day_budget > 0 and day_budget_show_mode = 'stretched');

            insert into [{insert_target}] with truncate
            select
                c.cid as cid,
                c.order_id as order_id,
                c.client_id as client_id,
                nvl(c.type, 'other') as type,
                (c.status_show) as is_status_show,
                (c.status_active) as is_status_active,
                (c.status_archived) as is_status_archived,
                ($context_budget_share > 0 and $context_budget_share < 100) as is_context_capped,
                $is_search_enabled as is_search_enabled,
                $is_context_enabled as is_context_enabled,
                -- >0 только для стратегий с самостоятельным управлением ставками.
                -- Проверь, что в остальных случаях (автобюджет) = 0.
                if($has_day_budget, day_budget) as day_budget_sum,
                (coalesce(c.day_budget, 0) > 0) as is_day_budget_capped,
                (coalesce(c.day_budget, 0) > 0 and c.day_budget_show_mode = 'stretched') as is_day_budget_stretched,
                (c.wallet_cid is not null) as has_wallet,
                (coalesce(c.wallet_autopay_mode, '') = 'min_balance') as has_enabled_autopayment,
                c.enabled_sms as is_sms_enabled,
                coalesce((ListLength(c.metrika_counters) > 0), false) as has_metrika_counters,
                coalesce((ListLength(c.geo) > 0), false) as has_geo_targeting,
                coalesce(c.minus_words, '') != '' as has_minus_words,
                (not c.broad_match_flag or c.broad_match_limit = 0 or type = 'performance') as is_drf_disabled,
                (not c.status_behavior) as is_behavioral_targeting_disabled,
                (not c.auto_optimization) as is_autofocus_disabled,
                (not c.status_open_stat) as is_openstat_disabled,
                (not c.status_metrica_control) as is_metrica_control_disabled,
                $has_good_domain(c.dont_show) as has_good_domains_disabled,

                coalesce(dm.dem_multipliers_inc, 0) > 0 as has_increasing_demography_multipliers,
                coalesce(dm.dem_multipliers_dec, 0) > 0 as has_decreasing_demography_multipliers,
                coalesce(rm.ret_multipliers_inc, 0) > 0 as has_increasing_retargeting_multipliers,
                coalesce(rm.ret_multipliers_dec, 0) > 0 as has_decreasing_retargeting_multipliers,
                coalesce(mm.mob_multipliers_inc, 0) > 0 as has_increasing_mobile_multipliers,
                coalesce(mm.mob_multipliers_dec, 0) > 0 as has_decreasing_mobile_multipliers,

                strategy_name AS strategy_name_original,
                case when $is_auto
                     then case when strategy_name = 'autobudget'
                               then 'Автобюджет: Недельный бюджет'
                               when strategy_name = 'autobudget_week_bundle'
                               then 'Автобюджет: Недельный пакет кликов'
                               when strategy_name = 'autobudget_avg_click'
                               then 'Автобюджет: Средняя цена клика'
                               when strategy_name = 'autobudget_avg_cpa'
                               then 'Автобюджет: Средняя цена конверсии'
                               when strategy_name = 'autobudget_roi'
                               then 'Автобюджет: Средняя рентабельность инвестиций'
                               when strategy_name = 'autobudget_avg_cpi'
                               then 'Автобюджет: Средняя цена установки приложения'
                               when strategy_name = 'autobudget_avg_cpc_per_camp'
                               then 'Автобюджет: Оптимизация количества кликов (CPC на всю кампанию)'
                               when strategy_name = 'autobudget_avg_cpc_per_filter'
                               then 'Автобюджет: Оптимизация количества кликов (CPC на каждый фильтр)'
                               when strategy_name = 'autobudget_avg_cpa_per_camp'
                               then 'Автобюджет: Оптимизация количества конверсий (CPA на всю кампанию)'
                               when strategy_name = 'autobudget_avg_cpa_per_filter'
                               then 'Автобюджет: Оптимизация количества конверсий (CPA на каждый фильтр)'
                               else CAST(NULL as String)
                          end
                     else case when $is_search_enabled
                               then 'Ручное управление: Показ на наивысшей доступной позиции '
                                    || if($is_premium_only, 'в спецразмещении', if($is_guarantee_only, 'под результатами поиска', 'в спецразмещении и гарантии'))
                                    || if($is_context_enabled, ' + максимальный охват в сети', '')
                               when $is_context_enabled
                               then 'Ручное управление: Максимальных охват в сети'
                               else CAST(NULL as String)
                          end
                end as strategy_name,

                $is_auto       as is_auto_strategy,
                $is_min_price  as is_min_price_strategy,
                $is_max_pos    as is_max_pos_strategy,
                $is_premium    as is_premium_strategy,
                $is_guarantee  as is_guarantee_strategy,

                if(c.autobudget_sum > 0, c.autobudget_sum) as autobudget_sum,
                if(autobudget_bid > 0, autobudget_bid) as autobudget_max_bid,
                if(autobudget_avg_bid > 0, autobudget_avg_bid) as autobudget_avg_bid,
                if(
                    type = 'mobile_content',
                    if(autobudget_avg_cpi > 0, autobudget_avg_cpi),
                    if(autobudget_avg_cpa > 0, autobudget_avg_cpa)
                ) as autobudget_avg_cpa,
                if(autobudget_filter_avg_bid > 0, autobudget_filter_avg_bid) as autobudget_filter_avg_bid,
                if(autobudget_filter_avg_cpa > 0, autobudget_filter_avg_cpa) as autobudget_filter_avg_cpa,
                autobudget_goal_id,

                c.time_target as time_target,
                c.timezone_id as timezone_id
            from $campaigns as c
            left outer join $mobile_multipliers as mm on (mm.cid = c.cid)
            left outer join $demography_multipliers as dm on (dm.cid = c.cid)
            left outer join $retargeting_multipliers as rm on (rm.cid = c.cid)
            order by cid;
    """

    dependencies = [MultipliersMobileCids, MultipliersDemographyCids, MultipliersRetargetingCids, CloseCampaigns]


class CloseUsers(CloseCommon):
    title = 'close_users'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/users'


class Users(CubeCommonYqlSelectTarget):
    title = 'users'

    query = """
            insert into [{insert_target}] with truncate
            SELECT
                coalesce(uid, 0) as uid,
                coalesce(ClientID, 0) as client_id,
                login,
                lang as language,
                coalesce(statusArch = "Yes", false)        as is_archived,
                coalesce(statusBlocked = "Yes", false)     as is_blocked,
                coalesce(statusEasy = "Yes", false)        as is_easy_interface,
                coalesce(sendClientLetters = "Yes", false) as is_send_letters_enabled,
                coalesce(sendClientSMS = "Yes", false)     as is_send_sms_enabled,
                coalesce(sendNews = "Yes", false)          as is_send_news_enabled,
                coalesce(sendAccNews = "Yes", false)       as is_send_acc_news_enabled,
                coalesce(sendWarn = "Yes", false)          as is_send_warn_enabled
            from [{dependencies[0]}]
            where ClientID > 0 and uid > 0
            order by uid
    """

    dependencies = [CloseUsers]


class Clients(CubeCommonYqlSelectTarget):
    title = 'clients'

    query = """
        $campaigns = (
            select
                c.client_id,
                max(c.has_wallet) as has_wallet,
                min(c.has_enabled_autopayment) as has_enabled_autopayment
            from [{dependencies[0]}] as c
            group by client_id
            order by client_id
        );
        $users = (
            select
                client_id,
                max(is_archived) as is_archived,
                min(is_blocked) as is_blocked,
                case when min(is_easy_interface) = max(is_easy_interface) then max(is_easy_interface) else cast(NULL as Bool) end as is_easy_interface,
                case when min(is_send_letters_enabled) = max(is_send_letters_enabled) then max(is_send_letters_enabled) else cast(NULL as Bool) end as is_send_letters_enabled,
                case when min(is_send_sms_enabled) = max(is_send_sms_enabled) then max(is_send_sms_enabled) else cast(NULL as Bool) end as is_send_sms_enabled,
                case when min(is_send_news_enabled) = max(is_send_news_enabled) then max(is_send_news_enabled) else cast(NULL as Bool) end as is_send_news_enabled,
                case when min(is_send_acc_news_enabled) = max(is_send_acc_news_enabled) then max(is_send_acc_news_enabled) else cast(NULL as Bool) end as is_send_acc_news_enabled,
                case when min(is_send_warn_enabled) = max(is_send_warn_enabled) then max(is_send_warn_enabled) else cast(NULL as Bool) end as is_send_warn_enabled
            from [{dependencies[1]}] as c
            group by client_id
            order by client_id
        );
        insert into [{insert_target}] with truncate
        select
            c.client_id as client_id,
            c.has_wallet as has_wallet,
            c.has_enabled_autopayment as has_enabled_autopayment,
            u.is_archived as is_archived,
            u.is_blocked as is_blocked,
            u.is_easy_interface as is_easy_interface,
            u.is_send_letters_enabled as is_send_letters_enabled,
            u.is_send_sms_enabled as is_send_sms_enabled,
            u.is_send_news_enabled as is_send_news_enabled,
            u.is_send_acc_news_enabled as is_send_acc_news_enabled,
            u.is_send_warn_enabled as is_send_warn_enabled
        from $campaigns as c
        left outer join $users as u using (client_id)
        order by client_id
    """

    dependencies = [Campaigns, Users]


class CampaignsJoined(CubeCommonYqlSelectTarget):
    title = 'campaigns_joined'

    query = """
            insert into [{insert_target}] with truncate
            select
                campaigns.cid                                         as cid,
                campaigns.order_id                                    as order_id,
                campaigns.client_id                                   as client_id,
                campaigns.type                                        as campaign_type,
                campaigns.is_status_show                              as campaign_is_status_show,
                campaigns.is_status_active                            as campaign_is_status_active,
                campaigns.is_status_archived                          as campaign_is_status_archived,
                campaigns.is_context_capped                           as campaign_is_context_capped,
                campaigns.is_search_enabled                           as campaign_is_search_enabled,
                campaigns.is_context_enabled                          as campaign_is_context_enabled,
                campaigns.is_auto_strategy                            as campaign_is_auto_strategy,
                campaigns.is_max_pos_strategy                         as campaign_is_max_pos_strategy,
                campaigns.is_premium_strategy                         as campaign_is_premium_strategy,
                campaigns.is_guarantee_strategy                       as campaign_is_guarantee_strategy,
                campaigns.is_day_budget_capped                        as campaign_is_day_budget_capped,
                campaigns.is_day_budget_stretched                     as campaign_is_day_budget_stretched,
                campaigns.day_budget_sum                              as campaign_day_budget_sum,
                campaigns.autobudget_sum                              as campaign_autobudget_sum,
                campaigns.autobudget_max_bid                          as campaign_autobudget_max_bid,
                campaigns.autobudget_avg_bid                          as campaign_autobudget_avg_bid,
                campaigns.autobudget_avg_cpa                          as campaign_autobudget_avg_cpa,
                campaigns.autobudget_filter_avg_bid                   as campaign_autobudget_filter_avg_bid,
                campaigns.autobudget_filter_avg_cpa                   as campaign_autobudget_filter_avg_cpa,
                campaigns.autobudget_goal_id                          as campaign_autobudget_goal_id,
                campaigns.strategy_name                               as campaign_strategy_name,
                campaigns.strategy_name_original                      as campaign_strategy_name_original,
                campaigns.has_wallet                                  as campaign_has_wallet,
                campaigns.has_enabled_autopayment                     as campaign_has_enabled_autopayment,
                campaigns.is_sms_enabled                              as campaign_is_sms_enabled,
                campaigns.has_metrika_counters                        as campaign_has_metrika_counters,
                campaigns.has_geo_targeting                           as campaign_has_geo_targeting,
                campaigns.has_minus_words                             as campaign_has_minus_words,
                campaigns.is_drf_disabled                             as campaign_is_drf_disabled,
                campaigns.is_behavioral_targeting_disabled            as campaign_is_behavioral_targeting_disabled,
                campaigns.is_autofocus_disabled                       as campaign_is_autofocus_disabled,
                campaigns.is_openstat_disabled                        as campaign_is_openstat_disabled,
                campaigns.is_metrica_control_disabled                 as campaign_is_metrica_control_disabled,
                campaigns.has_good_domains_disabled                   as campaign_has_good_domains_disabled,
                campaigns.has_increasing_demography_multipliers       as campaign_has_increasing_demography_multipliers,
                campaigns.has_decreasing_demography_multipliers       as campaign_has_decreasing_demography_multipliers,
                campaigns.has_increasing_retargeting_multipliers      as campaign_has_increasing_retargeting_multipliers,
                campaigns.has_decreasing_retargeting_multipliers      as campaign_has_decreasing_retargeting_multipliers,
                campaigns.has_increasing_mobile_multipliers           as campaign_has_increasing_mobile_multipliers,
                campaigns.has_decreasing_mobile_multipliers           as campaign_has_decreasing_mobile_multipliers,
                campaigns.time_target                                 as campaign_time_target,
                campaigns.timezone_id                                 as campaign_timezone_id,
                clients.is_blocked                                    as client_is_blocked,
                clients.is_archived                                   as client_is_archived,
                clients.has_wallet                                    as client_has_wallet,
                clients.has_enabled_autopayment                       as client_has_enabled_autopayment,
                clients.is_easy_interface                             as client_uses_easy_interface,
                clients.is_send_letters_enabled                       as client_enables_send_letters,
                clients.is_send_sms_enabled                           as client_enables_send_sms,
                clients.is_send_news_enabled                          as client_enables_send_news,
                clients.is_send_acc_news_enabled                      as client_enables_send_acc_news,
                clients.is_send_warn_enabled                          as client_enables_send_warn
            from [{dependencies[1]}] as campaigns
            left outer join [{dependencies[0]}] as clients using (client_id)
            order by cid
    """

    dependencies = [Clients, Campaigns]


class CloseBids(CloseCommon):
    title = 'close_bids'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/bids'


class ClosePhrases(CloseCommon):
    title = 'close_bids_phrases'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/phrases'


class BannerGroups(CubeCommonYqlSelectTarget):
    title = 'banner_groups'

    query = """
           $mobile_multipliers = (
                select
                    cid,
                    pid,
                    count(*) as mob_multipliers,
                    count_if(mult > 100) as mob_multipliers_inc,
                    count_if(mult < 100) as mob_multipliers_dec
                from [{dependencies[1]}]
                group by cid, pid
            );
            $demography_multipliers = (
                select
                    cid,
                    pid,
                    count(*) as dem_multipliers,
                    count_if(mult > 100) as dem_multipliers_inc,
                    count_if(mult < 100) as dem_multipliers_dec,
                    count_if(age is not null) as age_multipliers,
                    count_if(age is not null and mult > 100) as age_multipliers_inc,
                    count_if(age is not null and mult < 100) as age_multipliers_dec,
                    count_if(gender is not null) as gender_multipliers,
                    count_if(gender is not null and mult > 100) as gender_multipliers_inc,
                    count_if(gender is not null and mult < 100) as gender_multipliers_dec,
                    count_if(age is not null and gender is not null) as age_gender_multipliers,
                    count_if(age is not null and gender is not null and mult > 100) as age_gender_multipliers_inc,
                    count_if(age is not null and gender is not null and mult < 100) as age_gender_multipliers_dec
                from [{dependencies[2]}]
                group by cid, pid
            );
           $retargeting_multipliers = (
                select
                    cid,
                    pid,
                    count(*) as ret_multipliers,
                    count_if(mult > 100) as ret_multipliers_inc,
                    count_if(mult < 100) as ret_multipliers_dec
                from [{dependencies[3]}]
                group by cid, pid
            );
            $retargeting_goals = (
                select
                    cid,
                    pid,
                    count(*) as goals,
                    count_if(goal_type = "metrika-goal") as metrika_goals,
                    count_if(goal_type = "metrika-counter") as metrika_counters,
                    count_if(goal_type = "metrika-segment") as metrika_segments,
                    count_if(goal_type = "audience-segment") as audience_segments
                from [{dependencies[0]}]
                group by cid, pid
            );
            $phrases = (
                select
                    cid,
                    pid,
                    count(*) as cnt
                    -- todo: moderation!
                from [{dependencies[4]}]
                group by cid, pid
            );
            insert into [{insert_target}] with truncate
            select
                b.cid as cid,
                b.pid as pid,
                coalesce(b.mw_id, 0) > 0 as has_minus_words,
                coalesce(b.geo, '') != '' as has_geo_targeting,
                coalesce(g.goals, 0) > 0 as has_retargeting_conditions,
                coalesce(g.metrika_goals, 0) > 0 or coalesce(g.metrika_counters, 0) > 0 or coalesce(g.metrika_segments, 0) > 0 as has_metrika_conditions,
                coalesce(g.audience_segments, 0) > 0 as has_audience_conditions,
                coalesce(dm.dem_multipliers_inc, 0) > 0 as has_increasing_demography_multipliers,
                coalesce(dm.dem_multipliers_dec, 0) > 0 as has_decreasing_demography_multipliers,
                coalesce(rm.ret_multipliers_inc, 0) > 0 as has_increasing_retargeting_multipliers,
                coalesce(rm.ret_multipliers_dec, 0) > 0 as has_decreasing_retargeting_multipliers,
                coalesce(mm.mob_multipliers_inc, 0) > 0 as has_increasing_mobile_multipliers,
                coalesce(mm.mob_multipliers_dec, 0) > 0 as has_decreasing_mobile_multipliers,
                coalesce(p.cnt, 0) as phrase_count
            -- todo: moderation!
            from [{dependencies[5]}] as b
            left outer join $phrases as p on (p.cid = b.cid and p.pid = b.pid)
            left outer join $retargeting_goals as g on (g.cid = b.cid and g.pid = b.pid)
            left outer join $mobile_multipliers as mm on (mm.cid = b.cid and mm.pid = b.pid)
            left outer join $demography_multipliers as dm on (dm.cid = b.cid and dm.pid = b.pid)
            left outer join $retargeting_multipliers as rm on (rm.cid = b.cid and rm.pid = b.pid)
            order by cid, pid;
    """

    dependencies = [RetargetingGoals, MultipliersMobilePids, MultipliersDemographyPids, MultipliersRetargetingPids, CloseBids, ClosePhrases]


class BannerGroupsJoined(CubeCommonYqlSelectTarget):
    title = 'banner_groups_joined'

    query = """
            insert into [{insert_target}] with truncate
            select
                banner_groups.cid                                                as cid,
                banner_groups.pid                                                as pid,
                campaigns.order_id                                               as order_id,
                campaigns.client_id                                              as client_id,
                banner_groups.has_minus_words                                    as banner_group_has_minus_words,
                banner_groups.has_geo_targeting                                  as banner_group_has_geo_targeting,
                banner_groups.has_retargeting_conditions                         as banner_group_has_retargeting_conditions,
                banner_groups.has_metrika_conditions                             as banner_group_has_metrika_conditions,
                banner_groups.has_audience_conditions                            as banner_group_has_audience_conditions,
                banner_groups.has_increasing_demography_multipliers              as banner_group_has_increasing_demography_multipliers,
                banner_groups.has_decreasing_demography_multipliers              as banner_group_has_decreasing_demography_multipliers,
                banner_groups.has_increasing_retargeting_multipliers             as banner_group_has_increasing_retargeting_multipliers,
                banner_groups.has_decreasing_retargeting_multipliers             as banner_group_has_decreasing_retargeting_multipliers,
                banner_groups.has_increasing_mobile_multipliers                  as banner_group_has_increasing_mobile_multipliers,
                banner_groups.has_decreasing_mobile_multipliers                  as banner_group_has_decreasing_mobile_multipliers,
                banner_groups.phrase_count                                       as banner_group_phrase_count,
                campaigns.campaign_type                                          as campaign_type,
                campaigns.campaign_is_status_show                                as campaign_is_status_show,
                campaigns.campaign_is_status_active                              as campaign_is_status_active,
                campaigns.campaign_is_status_archived                            as campaign_is_status_archived,
                campaigns.campaign_is_context_capped                             as campaign_is_context_capped,
                campaigns.campaign_is_search_enabled                             as campaign_is_search_enabled,
                campaigns.campaign_is_context_enabled                            as campaign_is_context_enabled,
                campaigns.campaign_is_auto_strategy                              as campaign_is_auto_strategy,
                campaigns.campaign_is_max_pos_strategy                           as campaign_is_max_pos_strategy,
                campaigns.campaign_is_premium_strategy                           as campaign_is_premium_strategy,
                campaigns.campaign_is_guarantee_strategy                         as campaign_is_guarantee_strategy,
                campaigns.campaign_is_day_budget_capped                          as campaign_is_day_budget_capped,
                campaigns.campaign_is_day_budget_stretched                       as campaign_is_day_budget_stretched,
                campaigns.campaign_day_budget_sum                                as campaign_day_budget_sum,
                campaigns.campaign_autobudget_sum                                as campaign_autobudget_sum,
                campaigns.campaign_autobudget_max_bid                            as campaign_autobudget_max_bid,
                campaigns.campaign_autobudget_avg_bid                            as campaign_autobudget_avg_bid,
                campaigns.campaign_autobudget_avg_cpa                            as campaign_autobudget_avg_cpa,
                campaigns.campaign_autobudget_filter_avg_bid                     as campaign_autobudget_filter_avg_bid,
                campaigns.campaign_autobudget_filter_avg_cpa                     as campaign_autobudget_filter_avg_cpa,
                campaigns.campaign_autobudget_goal_id                            as campaign_autobudget_goal_id,
                campaigns.campaign_strategy_name                                 as campaign_strategy_name,
                campaigns.campaign_strategy_name_original                        as campaign_strategy_name_original,
                campaigns.campaign_has_wallet                                    as campaign_has_wallet,
                campaigns.campaign_has_enabled_autopayment                       as campaign_has_enabled_autopayment,
                campaigns.campaign_is_sms_enabled                                as campaign_is_sms_enabled,
                campaigns.campaign_has_metrika_counters                          as campaign_has_metrika_counters,
                campaigns.campaign_has_geo_targeting                             as campaign_has_geo_targeting,
                campaigns.campaign_has_minus_words                               as campaign_has_minus_words,
                campaigns.campaign_is_drf_disabled                               as campaign_is_drf_disabled,
                campaigns.campaign_is_behavioral_targeting_disabled              as campaign_is_behavioral_targeting_disabled,
                campaigns.campaign_is_autofocus_disabled                         as campaign_is_autofocus_disabled,
                campaigns.campaign_is_openstat_disabled                          as campaign_is_openstat_disabled,
                campaigns.campaign_is_metrica_control_disabled                   as campaign_is_metrica_control_disabled,
                campaigns.campaign_has_good_domains_disabled                     as campaign_has_good_domains_disabled,
                campaigns.campaign_has_increasing_demography_multipliers         as campaign_has_increasing_demography_multipliers,
                campaigns.campaign_has_decreasing_demography_multipliers         as campaign_has_decreasing_demography_multipliers,
                campaigns.campaign_has_increasing_retargeting_multipliers        as campaign_has_increasing_retargeting_multipliers,
                campaigns.campaign_has_decreasing_retargeting_multipliers        as campaign_has_decreasing_retargeting_multipliers,
                campaigns.campaign_has_increasing_mobile_multipliers             as campaign_has_increasing_mobile_multipliers,
                campaigns.campaign_has_decreasing_mobile_multipliers             as campaign_has_decreasing_mobile_multipliers,
                campaigns.campaign_time_target                                   as campaign_time_target,
                campaigns.campaign_timezone_id                                   as campaign_timezone_id,
                campaigns.client_is_blocked                                      as client_is_blocked,
                campaigns.client_is_archived                                     as client_is_archived,
                campaigns.client_has_wallet                                      as client_has_wallet,
                campaigns.client_has_enabled_autopayment                         as client_has_enabled_autopayment,
                campaigns.client_uses_easy_interface                             as client_uses_easy_interface,
                campaigns.client_enables_send_letters                            as client_enables_send_letters,
                campaigns.client_enables_send_sms                                as client_enables_send_sms,
                campaigns.client_enables_send_news                               as client_enables_send_news,
                campaigns.client_enables_send_acc_news                           as client_enables_send_acc_news,
                campaigns.client_enables_send_warn                               as client_enables_send_warn
            from [{dependencies[0]}] as banner_groups
            left outer join [{dependencies[1]}] as campaigns on (campaigns.cid = banner_groups.cid)
            order by cid, pid
    """

    dependencies = [BannerGroups, CampaignsJoined]


class CloseBanners(CloseCommon):
    title = 'close_banners'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/banners'


class CloseSitelinksSets(CloseCommon):
    title = 'close_sitelinks_sets'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/sitelinks_sets'


class CloseBannerImagesFormats(CloseCommon):
    title = 'banner_images_formats'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/banner_images_formats'


class Banners(CubeCommonYqlSelectTarget):
    title = 'banners'

    query = """
            $images = (
                select
                    image_hash,
                    max_by(image_type, height) as image_type,
                    max_by(height, height) as height,
                    max_by(width, height) as width
                from [{dependencies[0]}]
                group by image_hash
                order by image_hash
            );
            $sitelinks = (
                select
                    sitelinks_set_id,
                    count(*) as sitelinks,
                    count_if(coalesce(description, '') != '') as sitelinks_with_description
                from [{dependencies[1]}]
                group by sitelinks_set_id
                order by sitelinks_set_id
            );
            $callouts = ListLength(Yson::ConvertToInt64List(Yson::YPath(Yson::Parse(additions), "/callout")));
            -- $callouts = cast(NULL as Int64);
            $text_banners = (
                select
                    nvl(cid, 0) as cid,
                    nvl(pid, 0) as pid,
                    nvl(bid, 0) as bid,
                    cast(nvl(BannerID, 0) as UInt64) as banner_id,
                    banner_type,
                    type = 'mobile' as is_mobile,
                    False as is_image,
                    vcard_id > 0 as has_vcard,
                    statusShow = "Yes" as status_show,
                    statusArch = "Yes" as is_archived,
                    (coalesce(display_href, '') != '') ?? False and (display_href_status_moderate != 'No') ?? False as has_display_href,
                    ((sitelinks_set_id > 0) ?? False and (statusSitelinksModerate != 'No') ?? False) as has_sitelinks,
                    sitelinks_set_id,
                    $callouts as callouts,
                    if(banner_type = 'image_ad', image_ad_hash, image_hash) as image_hash
                from [{dependencies[2]}] as b
                where cid > 0 and pid > 0 and bid > 0 and BannerID > 0
                order by cid, pid, bid
            );
            $image_banners = (
                select
                    nvl(cid, 0) as cid,
                    nvl(pid, 0) as pid,
                    nvl(bid, 0) as bid,
                    cast(nvl(image_BannerID, 0) as UInt64) as banner_id,
                    banner_type,
                    type = 'mobile' as is_mobile,
                    True as is_image,
                    vcard_id > 0 as has_vcard,
                    statusShow = "Yes" as status_show,
                    statusArch = "Yes" as is_archived,
                    ((coalesce(display_href, '') != '') ?? False) and (display_href_status_moderate != 'No') ?? False as has_display_href,
                    ((sitelinks_set_id > 0) ?? False and (statusSitelinksModerate != 'No') ?? False) as has_sitelinks,
                    sitelinks_set_id,
                    $callouts as callouts,
                    if((banner_type = 'image_ad') ?? False, image_ad_hash, image_hash) as image_hash,
                    if((banner_type = 'image_ad') ?? False, image_ad_statusModerate, image_statusModerate) != "No" as image_moderated
                from [{dependencies[2]}] as b
                where cid > 0 and pid > 0 and bid > 0 and image_BannerID > 0
                order by cid, pid, bid
            );
            $all_banners = (
                select
                    b.cid as cid,
                    b.pid as pid,
                    b.bid as bid,
                    b.banner_id as banner_id,
                    b.is_mobile as is_mobile,
                    b.is_image as is_image,
                    b.status_show as status_show,
                    b.is_archived as is_archived,
                    b.has_vcard as has_vcard,
                    b.has_display_href as has_display_href,
                    b.has_sitelinks as has_sitelinks,
                    (coalesce(b.image_hash, '') != '') ?? False as has_image,
                    (coalesce(b.image_hash, '') != '') ?? False and b.image_moderated ?? False as has_moderated_image,
                    b.banner_type as banner_type,
                    b.image_hash as image_hash,
                    b.sitelinks_set_id as sitelinks_set_id,
                    b.callouts as callouts
                from (
                    select * from $text_banners union all
                    select * from $image_banners
                ) as b
                order by cid, pid, bid
            );
            $banners_with_image_info = (
                select
                    b.cid                 as cid,
                    b.pid                 as pid,
                    b.bid                 as bid,
                    b.banner_id           as banner_id,
                    b.is_mobile           as is_mobile,
                    b.is_image            as is_image,
                    b.status_show         as status_show,
                    b.is_archived         as is_archived,
                    b.has_vcard           as has_vcard,
                    b.has_display_href    as has_display_href,
                    b.has_sitelinks       as has_sitelinks,
                    b.has_image           as has_image,
                    b.has_moderated_image as has_moderated_image,
                    i.height              as image_height,
                    i.width               as image_width,
                    i.image_type          as image_type,
                    b.banner_type         as banner_type,
                    b.sitelinks_set_id    as sitelinks_set_id,
                    b.callouts            as callouts
                from $all_banners as b
                left outer join $images as i on b.image_hash = i.image_hash
                where b.image_hash is not null
                union all
                select
                    b.cid                 as cid,
                    b.pid                 as pid,
                    b.bid                 as bid,
                    b.banner_id           as banner_id,
                    b.is_mobile           as is_mobile,
                    b.is_image            as is_image,
                    b.status_show         as status_show,
                    b.is_archived         as is_archived,
                    b.has_vcard           as has_vcard,
                    b.has_display_href    as has_display_href,
                    b.has_sitelinks       as has_sitelinks,
                    b.has_image           as has_image,
                    b.has_moderated_image as has_moderated_image,
                    cast(NULL as Int64)   as image_height,
                    cast(NULL as Int64)   as image_width,
                    cast(NULL as String)  as image_type,
                    b.banner_type         as banner_type,
                    b.sitelinks_set_id    as sitelinks_set_id,
                    b.callouts            as callouts
                from $all_banners as b
                where b.image_hash is null
            );
            $banners_with_sitelink_info = (
                select
                    b.cid                                      as cid,
                    b.pid                                      as pid,
                    b.bid                                      as bid,
                    b.banner_id                                as banner_id,
                    b.is_mobile                                as is_mobile,
                    b.is_image                                 as is_image,
                    b.status_show                              as status_show,
                    b.is_archived                              as is_archived,
                    b.has_vcard                                as has_vcard,
                    b.has_display_href                         as has_display_href,
                    b.has_sitelinks                            as has_sitelinks,
                    b.has_image                                as has_image,
                    b.has_moderated_image                      as has_moderated_image,
                    coalesce(sl.sitelinks, 0)                  as sitelinks_total,
                    coalesce(sl.sitelinks_with_description, 0) as sitelinks_with_description,
                    b.callouts                                 as callouts,
                    b.image_height                             as image_height,
                    b.image_width                              as image_width,
                    b.image_type                               as image_type,
                    b.banner_type                              as banner_type
                from $banners_with_image_info as b
                left outer join $sitelinks as sl on b.sitelinks_set_id = sl.sitelinks_set_id
                where b.sitelinks_set_id is not null
                union all
                select
                    b.cid                   as cid,
                    b.pid                   as pid,
                    b.bid                   as bid,
                    b.banner_id             as banner_id,
                    b.is_mobile             as is_mobile,
                    b.is_image              as is_image,
                    b.status_show           as status_show,
                    b.is_archived           as is_archived,
                    b.has_vcard             as has_vcard,
                    b.has_display_href      as has_display_href,
                    b.has_sitelinks         as has_sitelinks,
                    b.has_image             as has_image,
                    b.has_moderated_image   as has_moderated_image,
                    0                       as sitelinks_total,
                    0                       as sitelinks_with_description,
                    b.callouts              as callouts,
                    b.image_height          as image_height,
                    b.image_width           as image_width,
                    b.image_type            as image_type,
                    b.banner_type           as banner_type
                from $banners_with_image_info as b
                where b.sitelinks_set_id is null
                order by cid, pid, bid
            );
            insert into [{insert_target}] with truncate
            select
                cid,
                pid,
                bid,
                banner_id,
                is_mobile,
                is_image,
                status_show,
                is_archived,
                has_vcard,
                has_display_href,
                has_sitelinks,
                has_image,
                has_moderated_image,
                sitelinks_total,
                sitelinks_with_description,
                callouts,
                image_height,
                image_width,
                image_type,
                banner_type
            from $banners_with_sitelink_info
            order by cid, pid, bid;
    """

    dependencies = [CloseBannerImagesFormats, CloseSitelinksSets, CloseBanners]


class BannerJoined(CubeCommonYqlSelectTarget):
    title = 'banner_joined'

    query = """
            insert into [{insert_target}] with truncate
            select
                banners.banner_id                                                  as banner_id,
                banner_groups.order_id                                             as order_id,
                banner_groups.client_id                                            as client_id,
                banners.bid                                                        as bid,
                banners.pid                                                        as pid,
                banners.cid                                                        as cid,
                banners.is_mobile                                                  as banner_is_mobile,
                banners.has_vcard                                                  as banner_has_vcard,
                banners.has_display_href                                           as banner_has_display_href,
                banners.has_sitelinks                                              as banner_has_sitelinks,
                banners.has_image                                                  as banner_has_image,
                banners.has_moderated_image                                        as banner_has_moderated_image,
                banners.sitelinks_total                                            as banner_sitelinks_total,
                banners.sitelinks_with_description                                 as banner_sitelinks_with_description,
                banners.callouts                                                   as banner_callouts,
                banners.image_height                                               as banner_image_height,
                banners.image_width                                                as banner_image_width,
                banners.banner_type                                                as banner_type,
                banners.image_type                                                 as banner_image_type,
                banners.status_show                                                as banner_status_show,
                banners.is_archived                                                as banner_is_archived,
                banner_groups.banner_group_has_minus_words                         as banner_group_has_minus_words,
                banner_groups.banner_group_has_geo_targeting                       as banner_group_has_geo_targeting,
                banner_groups.banner_group_has_retargeting_conditions              as banner_group_has_retargeting_conditions,
                banner_groups.banner_group_has_metrika_conditions                  as banner_group_has_metrika_conditions,
                banner_groups.banner_group_has_audience_conditions                 as banner_group_has_audience_conditions,
                banner_groups.banner_group_has_increasing_demography_multipliers   as banner_group_has_increasing_demography_multipliers,
                banner_groups.banner_group_has_decreasing_demography_multipliers   as banner_group_has_decreasing_demography_multipliers,
                banner_groups.banner_group_has_increasing_retargeting_multipliers  as banner_group_has_increasing_retargeting_multipliers,
                banner_groups.banner_group_has_decreasing_retargeting_multipliers  as banner_group_has_decreasing_retargeting_multipliers,
                banner_groups.banner_group_has_increasing_mobile_multipliers       as banner_group_has_increasing_mobile_multipliers,
                banner_groups.banner_group_has_decreasing_mobile_multipliers       as banner_group_has_decreasing_mobile_multipliers,
                banner_groups.banner_group_phrase_count                            as banner_group_phrase_count,
                banner_groups.campaign_type                                        as campaign_type,
                banner_groups.campaign_is_status_show                              as campaign_is_status_show,
                banner_groups.campaign_is_status_active                            as campaign_is_status_active,
                banner_groups.campaign_is_status_archived                          as campaign_is_status_archived,
                banner_groups.campaign_is_context_capped                           as campaign_is_context_capped,
                banner_groups.campaign_is_search_enabled                           as campaign_is_search_enabled,
                banner_groups.campaign_is_context_enabled                          as campaign_is_context_enabled,
                banner_groups.campaign_is_auto_strategy                            as campaign_is_auto_strategy,
                banner_groups.campaign_is_max_pos_strategy                         as campaign_is_max_pos_strategy,
                banner_groups.campaign_is_premium_strategy                         as campaign_is_premium_strategy,
                banner_groups.campaign_is_guarantee_strategy                       as campaign_is_guarantee_strategy,
                banner_groups.campaign_is_day_budget_capped                        as campaign_is_day_budget_capped,
                banner_groups.campaign_is_day_budget_stretched                     as campaign_is_day_budget_stretched,
                banner_groups.campaign_day_budget_sum                              as campaign_day_budget_sum,
                banner_groups.campaign_autobudget_sum                              as campaign_autobudget_sum,
                banner_groups.campaign_autobudget_max_bid                          as campaign_autobudget_max_bid,
                banner_groups.campaign_autobudget_avg_bid                          as campaign_autobudget_avg_bid,
                banner_groups.campaign_autobudget_avg_cpa                          as campaign_autobudget_avg_cpa,
                banner_groups.campaign_autobudget_filter_avg_bid                   as campaign_autobudget_filter_avg_bid,
                banner_groups.campaign_autobudget_filter_avg_cpa                   as campaign_autobudget_filter_avg_cpa,
                banner_groups.campaign_autobudget_goal_id                          as campaign_autobudget_goal_id,
                banner_groups.campaign_strategy_name                               as campaign_strategy_name,
                banner_groups.campaign_strategy_name_original                      as campaign_strategy_name_original,
                banner_groups.campaign_has_wallet                                  as campaign_has_wallet,
                banner_groups.campaign_has_enabled_autopayment                     as campaign_has_enabled_autopayment,
                banner_groups.campaign_is_sms_enabled                              as campaign_is_sms_enabled,
                banner_groups.campaign_has_metrika_counters                        as campaign_has_metrika_counters,
                banner_groups.campaign_has_geo_targeting                           as campaign_has_geo_targeting,
                banner_groups.campaign_has_minus_words                             as campaign_has_minus_words,
                banner_groups.campaign_is_drf_disabled                             as campaign_is_drf_disabled,
                banner_groups.campaign_is_behavioral_targeting_disabled            as campaign_is_behavioral_targeting_disabled,
                banner_groups.campaign_is_autofocus_disabled                       as campaign_is_autofocus_disabled,
                banner_groups.campaign_is_openstat_disabled                        as campaign_is_openstat_disabled,
                banner_groups.campaign_is_metrica_control_disabled                 as campaign_is_metrica_control_disabled,
                banner_groups.campaign_has_good_domains_disabled                   as campaign_has_good_domains_disabled,
                banner_groups.campaign_has_increasing_demography_multipliers       as campaign_has_increasing_demography_multipliers,
                banner_groups.campaign_has_decreasing_demography_multipliers       as campaign_has_decreasing_demography_multipliers,
                banner_groups.campaign_has_increasing_retargeting_multipliers      as campaign_has_increasing_retargeting_multipliers,
                banner_groups.campaign_has_decreasing_retargeting_multipliers      as campaign_has_decreasing_retargeting_multipliers,
                banner_groups.campaign_has_increasing_mobile_multipliers           as campaign_has_increasing_mobile_multipliers,
                banner_groups.campaign_has_decreasing_mobile_multipliers           as campaign_has_decreasing_mobile_multipliers,
                banner_groups.campaign_time_target                                 as campaign_time_target,
                banner_groups.campaign_timezone_id                                 as campaign_timezone_id,
                banner_groups.client_is_blocked                                    as client_is_blocked,
                banner_groups.client_is_archived                                   as client_is_archived,
                banner_groups.client_has_wallet                                    as client_has_wallet,
                banner_groups.client_has_enabled_autopayment                       as client_has_enabled_autopayment,
                banner_groups.client_uses_easy_interface                           as client_uses_easy_interface,
                banner_groups.client_enables_send_letters                          as client_enables_send_letters,
                banner_groups.client_enables_send_sms                              as client_enables_send_sms,
                banner_groups.client_enables_send_news                             as client_enables_send_news,
                banner_groups.client_enables_send_acc_news                         as client_enables_send_acc_news,
                banner_groups.client_enables_send_warn                             as client_enables_send_warn
            from [{dependencies[1]}] as banners
            left outer join [{dependencies[0]}] as banner_groups on (banner_groups.cid = banners.cid and banner_groups.pid = banners.pid)
            order by banner_id;
    """

    dependencies = [BannerGroupsJoined, Banners]


class Stat(CubeCommonYqlSelectTarget):
    title = 'stat'

    query = """
            $parsed_options = String::SplitToList(options, ',');
            pragma inferscheme;
            insert into [{insert_target}] with truncate
            select
                  banner_id
                , parent_banner_id
                , order_id
                , domain_id
                , page_id
                , region_id
                , device_type
                , detailed_device_type
                , tag_id
                , type_id
                , position
                , context_type
                , select_type
                , product_type
                , is_rtb
                , is_picture
                , is_commerce
                , is_mobile
                , is_dynamic
                , is_performance
                , is_mobile_app
                , is_stationary_connection
                , is_parentless_performance
                , has_dnt
                , has_adblockers
                , event_date
                , sum(case when ((is_performance or is_parentless_performance) and parent_banner_id > 0) then 0 else shows end) as shows
                , sum(case when ((is_performance or is_parentless_performance) and parent_banner_id > 0) then shows else 0 end) as shows_performance
                , sum(clicks) as clicks
                , sum(cost) as cost
            from (
                select
                      bannerid  as banner_id
                    , CASE WHEN parentbannerid > 0
                           THEN parentbannerid
                           ELSE NULL
                      END as parent_banner_id
                    , orderid as order_id
                    , domainid as domain_id
                    , pageid  as page_id
                    , regionid as region_id
                    , devicetype as device_type
                    , CASE WHEN detaileddevicetype = "Android"       THEN 2
                           WHEN detaileddevicetype = "iOS"           THEN 3
                           WHEN detaileddevicetype = "Windows Phone" THEN 4
                           ELSE CAST(NULL AS UInt32)
                      END as detailed_device_type
                    , tagid  as tag_id
                    , typeid as type_id
                    , position as position
                    , contexttype as context_type
                    , selecttype as select_type
                    , producttype as product_type
                    , case when countertype = 1 then 1ul else 0ul end as shows
                    , case when countertype = 2 then 1ul else 0ul end as clicks
                    , CAST(eventcost AS Double) * 30 / 1000000 as cost
                    , DateTime::ToDate(DateTime::ToTimeZone(DateTime::FromSeconds(CAST(eventtime as Uint64)), 'Europe/Moscow')) as event_date
                    , options_dsp as is_rtb
                    , options_picture as is_picture
                    , options_commerce as is_commerce
                    , options_mobile as is_mobile
                    , [options_dynamic-banner] as is_dynamic
                    , options_performance as is_performance
                    , [options_mobile-app] as is_mobile_app
                    , [options_stationary-connection] as is_stationary_connection
                    , [options_parentless-performance] as is_parentless_performance
                    , options_dnt as has_dnt
                    , options_los as has_adblockers
                from [//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d/{date:%Y-%m-%d}] as t
                where placeid = 542 and fraudbits = 0
            ) as a
            group by
                  banner_id
                , parent_banner_id
                , order_id
                , domain_id
                , page_id
                , region_id
                , device_type
                , detailed_device_type
                , tag_id
                , type_id
                , position
                , context_type
                , select_type
                , product_type
                , is_rtb
                , is_picture
                , is_commerce
                , is_mobile
                , is_dynamic
                , is_performance
                , is_mobile_app
                , is_stationary_connection
                , is_parentless_performance
                , has_dnt
                , has_adblockers
                , event_date
            order by banner_id;
"""


class CubeDay(CubeCommonYqlSelectTarget):
    title = 'cube_day'

    target_template_path = "{home}/{token}/cube/daily/{date:%Y-%m-%d}"

    query = """
            insert into [{insert_target}] with truncate
            select
                banners.client_id                                             as client_id,
                coalesce(stats.order_id, banners.order_id)                    as order_id,
                stats.parent_banner_id                                        as parent_banner_id,
                coalesce(stats.banner_id, banners.banner_id)                  as banner_id,
                banners.cid                                                   as cid,
                banners.pid                                                   as pid,
                banners.bid                                                   as bid,
                stats.domain_id                                               as domain_id,
                stats.page_id                                                 as page_id,
                stats.region_id                                               as region_id,
                stats.device_type                                             as device_type,
                stats.detailed_device_type                                    as detailed_device_type,
                stats.tag_id                                                  as tag_id,
                stats.type_id                                                 as type_id,
                stats.position                                                as position,
                stats.context_type                                            as context_type,
                stats.select_type                                             as select_type,
                stats.product_type                                            as product_type,
                stats.is_rtb                                                  as is_rtb,
                stats.is_picture                                              as is_picture,
                stats.is_commerce                                             as is_commerce,
                stats.is_mobile                                               as is_mobile,
                stats.is_dynamic                                              as is_dynamic,
                stats.is_performance                                          as is_performance,
                stats.is_mobile_app                                           as is_mobile_app,
                stats.is_stationary_connection                                as is_stationary_connection,
                stats.is_parentless_performance                               as is_parentless_performance,
                stats.has_dnt                                                 as has_dnt,
                stats.has_adblockers                                          as has_adblockers,
                stats.event_date                                              as event_date,
                stats.shows                                                   as shows,
                stats.shows_performance                                       as shows_performance,
                stats.clicks                                                  as clicks,
                stats.cost / 1.18                                             as cost_rub_wo_nds,
                banners.banner_is_mobile                                      as banner_is_mobile,
                banners.banner_has_vcard                                      as banner_has_vcard,
                banners.banner_has_display_href                               as banner_has_display_href,
                banners.banner_has_sitelinks                                  as banner_has_sitelinks,
                banners.banner_has_image                                      as banner_has_image,
                banners.banner_has_moderated_image                            as banner_has_moderated_image,
                banners.banner_sitelinks_total                                as banner_sitelinks_total,
                banners.banner_sitelinks_with_description                     as banner_sitelinks_with_description,
                banners.banner_callouts                                       as banner_callouts,
                banners.banner_image_height                                   as banner_image_height,
                banners.banner_image_width                                    as banner_image_width,
                banners.banner_type                                           as banner_type,
                banners.banner_image_type                                     as banner_image_type,
                banners.banner_status_show                                    as banner_status_show,
                banners.banner_is_archived                                    as banner_is_archived,
                banners.banner_group_has_minus_words                          as banner_group_has_minus_words,
                banners.banner_group_has_geo_targeting                        as banner_group_has_geo_targeting,
                banners.banner_group_has_retargeting_conditions               as banner_group_has_retargeting_conditions,
                banners.banner_group_has_metrika_conditions                   as banner_group_has_metrika_conditions,
                banners.banner_group_has_audience_conditions                  as banner_group_has_audience_conditions,
                banners.banner_group_has_increasing_demography_multipliers    as banner_group_has_increasing_demography_multipliers,
                banners.banner_group_has_decreasing_demography_multipliers    as banner_group_has_decreasing_demography_multipliers,
                banners.banner_group_has_increasing_retargeting_multipliers   as banner_group_has_increasing_retargeting_multipliers,
                banners.banner_group_has_decreasing_retargeting_multipliers   as banner_group_has_decreasing_retargeting_multipliers,
                banners.banner_group_has_increasing_mobile_multipliers        as banner_group_has_increasing_mobile_multipliers,
                banners.banner_group_has_decreasing_mobile_multipliers        as banner_group_has_decreasing_mobile_multipliers,
                banners.banner_group_phrase_count                             as banner_group_phrase_count,
                banners.campaign_type                                         as campaign_type,
                banners.campaign_is_status_show                               as campaign_is_status_show,
                banners.campaign_is_status_active                             as campaign_is_status_active,
                banners.campaign_is_status_archived                           as campaign_is_status_archived,
                banners.campaign_is_context_capped                            as campaign_is_context_capped,
                banners.campaign_is_search_enabled                            as campaign_is_search_enabled,
                banners.campaign_is_context_enabled                           as campaign_is_context_enabled,
                banners.campaign_is_auto_strategy                             as campaign_is_auto_strategy,
                banners.campaign_is_max_pos_strategy                          as campaign_is_max_pos_strategy,
                banners.campaign_is_premium_strategy                          as campaign_is_premium_strategy,
                banners.campaign_is_guarantee_strategy                        as campaign_is_guarantee_strategy,
                banners.campaign_is_day_budget_capped                         as campaign_is_day_budget_capped,
                banners.campaign_is_day_budget_stretched                      as campaign_is_day_budget_stretched,
                banners.campaign_day_budget_sum                               as campaign_day_budget_sum,
                banners.campaign_autobudget_sum                               as campaign_autobudget_sum,
                banners.campaign_autobudget_max_bid                           as campaign_autobudget_max_bid,
                banners.campaign_autobudget_avg_bid                           as campaign_autobudget_avg_bid,
                banners.campaign_autobudget_avg_cpa                           as campaign_autobudget_avg_cpa,
                banners.campaign_autobudget_filter_avg_bid                    as campaign_autobudget_filter_avg_bid,
                banners.campaign_autobudget_filter_avg_cpa                    as campaign_autobudget_filter_avg_cpa,
                banners.campaign_autobudget_goal_id                           as campaign_autobudget_goal_id,
                banners.campaign_strategy_name                                as campaign_strategy_name,
                banners.campaign_strategy_name_original                       as campaign_strategy_name_original,
                banners.campaign_is_sms_enabled                               as campaign_is_sms_enabled,
                banners.campaign_has_metrika_counters                         as campaign_has_metrika_counters,
                banners.campaign_has_geo_targeting                            as campaign_has_geo_targeting,
                banners.campaign_has_minus_words                              as campaign_has_minus_words,
                banners.campaign_is_drf_disabled                              as campaign_is_drf_disabled,
                banners.campaign_is_behavioral_targeting_disabled             as campaign_is_behavioral_targeting_disabled,
                banners.campaign_is_autofocus_disabled                        as campaign_is_autofocus_disabled,
                banners.campaign_is_openstat_disabled                         as campaign_is_openstat_disabled,
                banners.campaign_is_metrica_control_disabled                  as campaign_is_metrica_control_disabled,
                banners.campaign_has_good_domains_disabled                    as campaign_has_good_domains_disabled,
                banners.campaign_has_increasing_demography_multipliers        as campaign_has_increasing_demography_multipliers,
                banners.campaign_has_decreasing_demography_multipliers        as campaign_has_decreasing_demography_multipliers,
                banners.campaign_has_increasing_retargeting_multipliers       as campaign_has_increasing_retargeting_multipliers,
                banners.campaign_has_decreasing_retargeting_multipliers       as campaign_has_decreasing_retargeting_multipliers,
                banners.campaign_has_increasing_mobile_multipliers            as campaign_has_increasing_mobile_multipliers,
                banners.campaign_has_decreasing_mobile_multipliers            as campaign_has_decreasing_mobile_multipliers,
                banners.campaign_time_target                                  as campaign_time_target,
                banners.campaign_timezone_id                                  as campaign_timezone_id,
                banners.client_is_blocked                                     as client_is_blocked,
                banners.client_is_archived                                    as client_is_archived,
                banners.client_has_wallet                                     as client_has_wallet,
                banners.client_has_enabled_autopayment                        as client_has_enabled_autopayment
            from [{dependencies[1]}] as banners
            full outer join [{dependencies[0]}] as stats on (coalesce(stats.parent_banner_id, stats.banner_id) = banners.banner_id)
            order by client_id, order_id, parent_banner_id, banner_id

"""

    dependencies = [Stat, BannerJoined]
