# coding=utf-8
"""
Сборка кубов для комерческого департамента
"""
from __future__ import absolute_import, unicode_literals, print_function

from sandbox.projects.direct_internal_analytics.laborer.target_types.close_tables import CloseTableTarget
from sandbox.projects.direct_internal_analytics.laborer.target_types.base import YqlSelectTarget


class CloseBanner(CloseTableTarget):
    title = 'close_banner'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/banners'

    starttime_shift = 0

    time_step = -1

    step_count = 30


class ClosePhrase(CloseTableTarget):
    title = 'close_phrases'

    template = '//home/direct/db-archive/{date:%Y-%m-%d}/phrases'

    starttime_shift = 0

    time_step = -1

    step_count = 30


class Banner(YqlSelectTarget):
    title = 'banner'

    query = """
$script = @@
import hashlib

def hash(url):
    return int(int(hashlib.sha1(url).hexdigest(), 16) % (10 ** 15))
@@;

$hash = Python::hash("(String?)->Int64", $script);

$pre_banner = (

    select
        cast(Banner.image_BannerID as UInt64) as BannerID,
        Banner.LastChange as LastChange,
        Banner.href as href,
        Phrase.geo as geo,
        Url::CutQueryStringAndFragment(Banner.href) as norm_href,
        cast($hash(Url::CutQueryStringAndFragment(Banner.href)) as UInt64) as norm_href_hash
    from
        [{dependencies[0]}] as Banner
    inner join
        [{dependencies[1]}] as Phrase on Phrase.pid = Banner.pid
    where
        statusActive = "Yes"
    and
        (
            href like '%?%'
        or
            Url::GetPath(href) != '/'
        )
    and
        href not like '%about%'
    and
        href not like '%contact%'
    and
        banner_type not like '%dynamic%'
    and
        banner_type not like '%performance%'
    and
        image_BannerID > 0
    order by norm_href_hash
);

$banner_partition = (
    SELECT
        norm_href_hash,
        norm_href,
        href,
        geo,
        BannerID,
        ROW_NUMBER() OVER PositionIndex AS Cnt
    FROM $pre_banner
    WINDOW PositionIndex AS (
        PARTITION BY norm_href_hash
        ORDER BY LastChange desc
    )
);

insert into [{insert_target}] with truncate
select
    BannerID,
    href,
    geo,
    norm_href,
    norm_href_hash
from
    $banner_partition
where
    Cnt < 50
    """

    dependencies = [CloseBanner, ClosePhrase]


class WatchLog(YqlSelectTarget):
    title = 'watch_log'

    query = """
$script = @@
import hashlib

def hash(url):
    return int(int(hashlib.sha1(url).hexdigest(), 16) % (10 ** 15))
@@;

$hash = Python::hash("(String?)->Int64", $script);

$pre_watch = (
SELECT
    uniqid,
    max(regionid) as regionid,
    max(url) as url,
    max(Url::CutQueryStringAndFragment(url)) as norm_url,
    max(eventtime) as eventtime,
    norm_url_hash,
    count(*) as cnt
from
[//home/logfeller/logs/bs-watch-log/1d/{date:%Y-%m-%d}]
where
uniqid != "0"
group by
uniqid,
$hash(Url::CutQueryStringAndFragment(url)) as norm_url_hash
);

insert into [{insert_target}] with truncate
select
    uniqid,
    regionid,
    url,
    norm_url,
    norm_url_hash,
    eventtime
from
    $pre_watch
where
    cnt < 1000
"""


def get_query():
    where = ""

    for i in range(0, 50):

        if i > 0:
            where += " or "

        where += 'Geo::IsRegionInRegion(cast(WatchLog.regionid as Int32), cast(String::SplitToList(Banners.geo, ","){%d} as Int32) ?? -1000000)\n' % i

    return """
insert into [{{insert_target}}] with truncate
select
*
from
    [{{dependencies[1]}}] as WatchLog
inner join
    [{{dependencies[0]}}] as Banners on WatchLog.norm_url_hash = Banners.norm_href_hash
where
    Banners.geo = "0"
or
""" + "(" + where + ")"


class JoindeWarchBanner(YqlSelectTarget):
    title = "joined_watch_banner"

    final = True

    query = get_query()

    dependencies = [Banner, WatchLog]


class Final(YqlSelectTarget):
    title = 'final'

    query = """
$pre_pre_final = (
    select
        [Banners.BannerID] as bannerid,
        [WatchLog.uniqid] as uniqid,
        [WatchLog.eventtime] as eventtime,
        ROW_NUMBER() OVER PositionIndex AS Cnt
    from
        [{dependencies[0]}]
    WINDOW PositionIndex AS (
        partition by [WatchLog.uniqid], [WatchLog.norm_url_hash]
        order by [WatchLog.eventtime] desc
    )
);

$pre_final = (
    select
        bannerid,
        uniqid,
        eventtime,
        ROW_NUMBER() OVER PositionIndex AS Cnt
    from
        $pre_pre_final
    where
        Cnt < 5
    WINDOW PositionIndex AS (
        partition by uniqid
        order by eventtime desc
    )
);

insert into [{insert_target}] with truncate
SELECT
    cast(bannerid as Int64) as bannerid,
    cast(uniqid as UInt64) as uniqid,
    cast(eventtime as Uint64) as eventtime
from
    $pre_final
where
    Cnt < 80
order by
    uniqid,
    eventtime
"""

    dependencies = [JoindeWarchBanner]
