# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

from datetime import datetime

from sandbox.projects.direct_internal_analytics.laborer.target_types.http import GetHttpJsonDataTarget
from sandbox.projects.direct_internal_analytics.laborer.target_types.base import ClickHouseInsertTarget


class FetchReleases(GetHttpJsonDataTarget):
    title = "releases"
    final = True
    url = "https://bsint.yandex-team.ru/pcode/api/getConfig?" \
          "project=context&date_start={date:%Y-%m-%d}T00:00:00&date_end={date:%Y-%m-%d}T23:59:59"
    fields = (
        ('timestamp', lambda x: x['timestamp'].strftime('%Y-%m-%d %H:%M:%S')),
        ('author', lambda x: x.get('author', None)),
        ('is_deployed', lambda x: x.get('isDeployed', True)),
        ('id', lambda x: int(x['id'])),
        ('messages', lambda x: '\n'.join(x['messages']) or "Stable - {}".format(x['id'])),
        ('percent', lambda x: x['percent']),
        ('ticket', lambda x: x.get('ticket', None)),
        ('type', lambda x: x['type']),
    )

    @classmethod
    def get_items(cls, data):
        result = []
        for item in data['result']:
            timestamp = datetime.fromtimestamp(item['timestamp'] / 1000.0)
            for code_piece in item['code']:
                code_piece['timestamp'] = timestamp
                result.append(code_piece)

        return result

    @classmethod
    def should_process(cls, item, context):
        return item['timestamp'].date() == context['date']


class AprilUploadReleases(ClickHouseInsertTarget):
    title = 'releases_ch_upload'

    database = 'yabs'
    table = 'bs_releases'

    columns = (
        ('timestamp', {'type': 'string'}),
        ('author', {'type': 'string'}),
        ('is_deployed', {'type': 'bool'}),
        ('id', {'type': 'integer'}),
        ('messages', {'type': 'string'}),
        ('percent', {'type': 'integer'}),
        ('ticket', {'type': 'string'}),
        ('type', {'type': 'string'}),
    )
    dependencies = [FetchReleases]
    final = True
