# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import sys

from sandbox.projects.direct_internal_analytics.laborer.target_types.base import ClickHouseSelectTarget, YqlSelectTarget


class ClickHouseDomainDataTarget(ClickHouseSelectTarget):
    """Добавить описание о том, что делает эта штука"""
    title = 'clickhouse_data'
    query = """
        SELECT StartURLDomainHash as domain_hash
             , any(StartURLDomain) as domain
             , if(IsMobile, if(IsTablet, 4, 3), 5) AS device_type
             , sum(Sign) as visits
             , sum(Sign * IsBounce) as bounces
             , sum(Sign * Duration) as duration
             , sum(Sign * PageViews) as pageviews
             , sumIf(Sign, Duration >= 120) as visits_d120
             , sumIf(Sign * Duration, Duration >= 120) as duration_d120
             , sumIf(Sign * PageViews, Duration >= 120) as pageviews_d120
        FROM visits_all
        WHERE StartDate = toDate('{date:%Y-%m-%d}')
            AND IsRobot = 0
            AND CounterIDSerial = 1
            AND notEmpty(StartURLDomain) = 1
            AND (StartURLDomainHash % {chunks_num}) = {chunk}
        GROUP BY StartURLDomainHash, device_type;
    """

    columns = ('domain_hash', 'domain', 'device_type', 'visits', 'bounces', 'duration',
               'pageviews', 'visits_d120', 'duration_d120', 'pageviews_d120')
    columns_types = {c: 'integer' for c in columns}
    columns_types['domain'] = 'string'


def chunked_subclass(cls, chunks_num, n, streams_num=None):
    """Хелпер для создания в текущем модуле импортируемых классов.
    Нужен для того, чтобы не переписывать N раз класс выше
    """
    name_base = '{}_{}'.format(cls.__name__, chunks_num)
    name = '{}_{}'.format(name_base, n)

    attrs = {
        'title': '{}_{}_{}'.format(cls.title, chunks_num, n),
        'query': cls.query.replace('{chunks_num}', str(chunks_num)).replace('{chunk}', str(n)),
    }

    if streams_num is not None and n >= streams_num:
        assert streams_num >= 1

        dep_name = '{}_{}'.format(name_base, n - streams_num)
        attrs['dependencies'] = [sys.modules[__name__].__dict__[dep_name]]

    # Да, я динамически создаю классы в текущем модуле и нет, мне ни капельки не стыдно
    clazz = type(name.encode('utf-8'), (cls,), attrs)

    sys.modules[__name__].__dict__[name] = clazz
    return clazz


class ClickHouseDomainDataChunksCollector(YqlSelectTarget):
    chunks_num = 10

    title = 'full_clickhouse_data'
    query = """
        PRAGMA inferscheme;
        INSERT INTO [{insert_target}]
        SELECT
            domain
            , device_type
            , visits
            , bounces
            , duration
            , pageviews
            , visits_d120
            , duration_d120
            , pageviews_d120
        FROM CONCAT(""" + \
            ',\n'.join('[{dependencies[%s]}]' % n for n in range(chunks_num)) + """
        );
    """
    dependencies = [chunked_subclass(ClickHouseDomainDataTarget, chunks_num, n, streams_num=2)
                    for n in range(chunks_num)]
