# coding: utf-8

import glob

import sandbox.common.types.task as ctt
from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.disk.RunJugglerDiskPlaybook import RunJugglerDiskPlaybook
from sandbox.sdk2.vcs.svn import Arcadia


class RunJugglerDiskAnsible(sdk2.Task):
    """
    Apply juggler disk all playbooks
    """
    class Context(sdk2.Task.Context):
        child_tasks_ids = []

    def on_execute(self):
        if not self.Context.child_tasks_ids:
            checkout_path = "ansible-juggler"
            Arcadia.checkout("arcadia:/arc/trunk/arcadia/disk/admin/ansible-juggler/", checkout_path)
            for filename in [f.replace(checkout_path + '/', '') for f in glob.iglob(checkout_path + '/*.yml')]:
                child = RunJugglerDiskPlaybook(self, playbook_name=filename, description=filename, owner=self.owner)
                child.enqueue()
                self.Context.child_tasks_ids.append(child.id)

        if not all(sdk2.Task[t].status in ctt.Status.Group.FINISH for t in self.Context.child_tasks_ids):
            raise sdk2.WaitTask(self.Context.child_tasks_ids, ctt.Status.Group.FINISH, wait_all=True)

        success_tasks = [sdk2.Task[t].status == ctt.Status.SUCCESS for t in self.Context.child_tasks_ids]
        if not all(success_tasks):
            raise TaskFailure('Failed %s playbooks' % len(filter(lambda x: not x, success_tasks)))
        self.set_info('Applied %s playbooks' % len(success_tasks))
