# coding: utf-8

import os
import sys

import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sdk2.helpers import subprocess as sp


class RunJugglerDiskPlaybook(sdk2.Task):
    """
    Apply juggler disk playbook
    """
    class Requirements(sdk2.Task.Requirements):
        client_tags = (ctc.Tag.LINUX_TRUSTY | ctc.Tag.LINUX_XENIAL)
        dns = ctm.DnsType.DNS64
        environments = [
            PipEnvironment('ansible', '2.2.3.0', use_wheel=True),
            PipEnvironment('ansible-juggler2', '1.16', use_wheel=True),
        ]
        disk_space = 1024

    class Parameters(sdk2.Task.Parameters):
        playbook_name = sdk2.parameters.String('Playbook name', default='disk.yml')

    def on_execute(self):
        os.environ['JUGGLER_OAUTH_TOKEN'] = sdk2.Vault.data(self.owner, 'JUGGLER_OAUTH_TOKEN')
        checkout_path = "ansible-juggler"
        Arcadia.checkout("arcadia:/arc/trunk/arcadia/disk/admin/ansible-juggler/", checkout_path)
        with sdk2.helpers.ProcessLog(self, logger='ansible-runner-%s' % self.Parameters.playbook_name) as pl:
            script_dir = os.environ.get("PYTHONUSERBASE") or os.path.expanduser("~/.local/bin")
            for attempt in range(3):
                pl.logger.info('Attempt %d, run ansible-playbook', attempt)
                try:
                    sp.check_call(
                        [
                            sys.executable,
                            os.path.join(script_dir, "ansible-playbook"),
                            self.Parameters.playbook_name,
                        ],
                        stdout=pl.stdout, stderr=sp.STDOUT, cwd=checkout_path
                    )
                except sp.CalledProcessError:
                    pl.logger.warning('Attempt %d failed', attempt)
                else:
                    break
            else:
                raise TaskFailure('Failed to apply playbook: %s' % self.Parameters.playbook_name)
