# -*- coding: utf-8 -*-

import os

from sandbox import sdk2

import sandbox.common.types.task as ctt
from sandbox.projects.common.build.YaMake2 import ArcadiaProjectBuildParameters, YaMake2
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.nanny import nanny

from sandbox.projects.dj.resource_types import DjDoc


class BuildDjDoc(YaMake2, nanny.ReleaseToNannyTask2):
    """Build DJ doc"""

    class Parameters(sdk2.Task.Parameters):
        arcadia_params = build_parameters.ArcadiaParameters()
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        arcadia_project_build_parameters = ArcadiaProjectBuildParameters()

        with sdk2.parameters.String('Release to Nanny') as release_to_nanny:
            release_to_nanny.values[''] = '-'
            for status in [ctt.ReleaseStatus.TESTING, ctt.ReleaseStatus.STABLE]:
                release_to_nanny.values[status] = status

    def get_resources(self):
        return {
            DjDoc.name: {
                'resource_type': DjDoc,
                'resource_path': os.path.basename(DjDoc.arcadia_build_path),
                'description': DjDoc.name,
            }
        }

    def get_targets(self):
        return [os.path.dirname(DjDoc.arcadia_build_path)]

    def get_arts(self):
        return [{'path': DjDoc.arcadia_build_path}]

    def on_success(self, prev_status):
        if self.Parameters.release_to_nanny:
            additional_parameters = dict(
                releaser=self.author,
                release_status=self.Parameters.release_to_nanny,
                release_subject='DJ doc automatic release',
                email_notifications=dict(to=[], cc=[]),
            )
            nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
