from sandbox import sdk2
from sandbox.common.errors import TaskFailure

from sandbox.projects.dj.DjTestFreshProfileServer import DjTestFreshProfileServer


class DjAcceptFreshProfileServer(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        test_task = sdk2.parameters.Task(
            'DjTestFreshProfileServer task',
            required=True,
            task_type=DjTestFreshProfileServer,
        )

        latency_avg_limit = sdk2.parameters.Integer('Average latency limit, ms', required=False)
        latency_p99_limit = sdk2.parameters.Integer('P99 latency limit, ms', required=False)
        max_rss_limit = sdk2.parameters.Integer('Memory usage limit, MB', required=False)
        failed_requests_limit = sdk2.parameters.Integer('Limit on ratio of failed requests', required=False)

    def on_execute(self):
        stats = self.Parameters.test_task.Context.stats
        if not self.Parameters.latency_avg_limit and not self.Parameters.latency_p99_limit \
            and not self.Parameters.max_rss_limit and not self.Parameters.failed_requests_limit:
            raise TaskFailure('Either of limits should be specified')

        if self.Parameters.latency_p99_limit and stats['latency_p99'] > self.Parameters.latency_p99_limit:
            raise TaskFailure('P99 latency limit exceeded')

        if self.Parameters.latency_avg_limit and stats['latency_avg'] > self.Parameters.latency_avg_limit:
            raise TaskFailure('Average latency limit exceeded')

        if self.Parameters.max_rss_limit and stats['max_rss'] > self.Parameters.max_rss_limit:
            raise TaskFailure('Memory limit exceeded')

        if self.Parameters.failed_requests_limit and stats['failed_requests_ratio'] > self.Parameters.failed_requests_limit:
            raise TaskFailure('Failed request limit exceeded')

