import logging
import os
import tarfile

from sandbox import common
from sandbox import sdk2

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.svn import Arcadia
import sandbox.common.types.task as ctt

class DjBuildArchiveFromSvn(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Base task for building models archive"""

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)
        models_dir_path = sdk2.parameters.String("SVN dir with models", required=True)
        archive_resource_name = sdk2.parameters.String(
            "Sandbox resource name for svn archive",
            required=True
        )

    def on_execute(self):
        resource = sdk2.Resource[self.Parameters.archive_resource_name](self, "Directory with models", "models")
        resource_data = sdk2.ResourceData(resource)
        Arcadia.export(self.Parameters.models_dir_path + "@" + str(self.Parameters.svn_revision), resource_data.path)
        resource_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
