import base64
import json

import sandbox.common.types.task as ctt

from sandbox import sdk2

from sandbox.projects.dj.dj_report import DjReport


class DjRequestDiff:
    def __init__(self, request_url, reports_diff):
        self.request_url = request_url
        self.reports_diff = reports_diff


class DjCompareBasesearchResponsesResult:
    def __init__(self):
        self.binary_unequal_responses_count = 0
        self.requests_diff = []


class MyJsonEncoder(json.JSONEncoder):
    def default(self, o):
        if isinstance(o, set):
            return list(o)
        return o.__dict__


class DjCompareBasesearchResponses(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        responses_resource_1 = sdk2.parameters.Resource(
            'Basesearch responses resource 1 (old)',
            required=True
        )
        responses_resource_2 = sdk2.parameters.Resource(
            'Basesearch responses resource 2 (new)',
            required=True
        )
        result_resource_type = sdk2.parameters.String(
            'Comparison result resource type',
            required=True,
            default='OTHER_RESOURCE')
        raise_exception_on_diff = sdk2.parameters.Bool(
            'Raise exception on diff',
            required=False,
            default=False)
        ignore_features = sdk2.parameters.List(
            'Features to ignore',
            required=False,
            default=[])

    def on_create(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={'released': ctt.ReleaseStatus.STABLE, 'name': 'DjCompareBasesearchResponses'}
        ).first()

    def on_execute(self):
        from deepdiff import DeepDiff

        params = self.Parameters

        result = DjCompareBasesearchResponsesResult()

        responses_resource_data_1 = sdk2.ResourceData(params.responses_resource_1)
        responses_file_1 = open(str(responses_resource_data_1.path), 'r')
        responses_resource_data_2 = sdk2.ResourceData(params.responses_resource_2)
        responses_file_2 = open(str(responses_resource_data_2.path), 'r')
        while True:
            responses_file_line_1 = responses_file_1.readline()
            responses_file_line_2 = responses_file_2.readline()
            if responses_file_line_1 == '' and responses_file_line_2 == '':
                break
            elif (responses_file_line_1 == '' and responses_file_line_2 != '') or (responses_file_line_1 != '' and responses_file_line_2 == ''):
                raise Exception('The number of lines in both files must be equal')
            else:
                request_1, response_1 = responses_file_line_1.split('\t')
                request_2, response_2 = responses_file_line_2.split('\t')
                if request_1 != request_2:
                    raise Exception('All request pairs must be equal')
                if response_1 != response_2:
                    result.binary_unequal_responses_count += 1
                    report_1 = DjReport(base64.b64decode(response_1), params.ignore_features)
                    report_2 = DjReport(base64.b64decode(response_2), params.ignore_features)
                    reports_diff = DeepDiff(report_1, report_2)
                    if reports_diff:
                        request_diff = DjRequestDiff(request_1, reports_diff)
                        result.requests_diff.append(request_diff)

        result_resource = sdk2.Resource[params.result_resource_type](
            self, 'DJ basesearch responses comparison result', 'result')
        result_resource_data = sdk2.ResourceData(result_resource)
        result_file = open(str(result_resource_data.path), 'w')
        result_file.write(json.dumps(result, cls=MyJsonEncoder))
        result_resource_data.ready()

        if result.requests_diff and params.raise_exception_on_diff:
            raise Exception('Comparison result contains diff')
