# coding: utf-8

from sandbox import sdk2
from sandbox import common
from sandbox.projects.resource_types import PLAIN_TEXT_QUERIES
from sandbox.sdk2.helpers import subprocess as sp

import os


class DjGenerateBasesearchRequests(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String(
            "YT proxy",
            required=True
        )
        yt_token_vault = sdk2.parameters.String(
            "YT token vault",
            required=True
        )
        profiles = sdk2.parameters.String(
            "YT table with profiles",
            required=True
        )
        context_counter_type = sdk2.parameters.String(
            "Context counter type",
            required=False
        )
        resource_id = sdk2.parameters.Resource(
            'Basesearch plan generator resource',
            required=True
        )
        queries_file_name = sdk2.parameters.String(
            "Queries file name",
            required=True,
            default="plan.txt"
        )
        queries_resource_type = sdk2.parameters.String(
            "Sandbox resource type for queries",
            required=True,
            default=PLAIN_TEXT_QUERIES.name
        )
        requests_count = sdk2.parameters.Integer(
            "Requests count",
            default=10000
        )

    def on_execute(self):
        generator_resource_data_path = str(sdk2.ResourceData(self.Parameters.resource_id).path)

        queries_resource = sdk2.Resource[self.Parameters.queries_resource_type](
            self, "Queries file", self.Parameters.queries_file_name
        )
        queries_resource_data = sdk2.ResourceData(queries_resource)

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.Parameters.yt_token_vault)

        subprocess_args = [
            generator_resource_data_path,
            "--cluster", self.Parameters.cluster,
            "--profiles", self.Parameters.profiles,
            "--output", str(queries_resource_data.path),
            "--num-queries", str(self.Parameters.requests_count),
        ]
        if self.Parameters.context_counter_type:
            subprocess_args.extend(["--context-counter-type", self.Parameters.context_counter_type])

        with sdk2.helpers.ProcessLog(self, logger="plan_generator_log") as pl:
            ret_code = sp.Popen(subprocess_args, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure('Plan generator run failed')
        queries_resource_data.ready()
