from sandbox import sdk2
from sandbox.projects.common import task_env
from sandbox.projects.common import binary_task


class DjZenQuantifiers(sdk2.Resource):
    """
    Serialized zen quantifiers
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['MLMARINES', 'jisuto', 'robot-dj-unity']


class DjPackZenQuantifiers(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        yt_token_vault = sdk2.parameters.String(
            'YT token vault',
            required=True,
            default='dj_unity_yt_token'
        )

        yt_proxy = sdk2.parameters.String(
            'YT proxy',
            required=True,
            default='arnold'
        )

        quantifiers_dir = sdk2.parameters.String(
            'Zen quantifiers directory',
            required=True,
            default='//home/zen/quantifiers'
        )

        ext_params = binary_task.binary_release_parameters(stable=True)

    class Requirements(task_env.TinyRequirements):
        pass

    def on_execute(self):
        from dj.lib.zen.proto import quantifiers_pb2
        from zen.integration.proto2 import Quantifier_pb2
        import yt.wrapper as yt

        params = self.Parameters
        resource = DjZenQuantifiers(self, 'Quantifiers', 'quantifiers.pb')
        resource_data = sdk2.ResourceData(resource)

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault)
        yt_client = yt.YtClient(proxy=params.yt_proxy, token=yt_token)

        tree = yt_client.get(params.quantifiers_dir)
        quantifiers = quantifiers_pb2.TQuantifiers()
        zen_quantifiers = Quantifier_pb2.EmbeddingMinMaxQuantifier()

        for zen_model in tree:
            for feature_type in tree[zen_model]:
                for version in tree[zen_model][feature_type]:
                    if 'proto_quantifiers' in tree[zen_model][feature_type][version]:
                        filepath = yt.ypath_join(params.quantifiers_dir, zen_model, feature_type, version, 'proto_quantifiers')
                        file = yt_client.read_file(filepath)
                        zen_quantifiers.ParseFromString(file.read())

                        for zen_quantifier in zen_quantifiers.quantifier:
                            assert len(zen_quantifier.min) == len(zen_quantifier.max)

                            quantifier = quantifiers.Quantifiers.add()
                            quantifier.ZenModel = zen_model
                            quantifier.ProfileType = zen_quantifier.quantifier_key
                            quantifier.Version = int(version.strip('v'))
                            quantifier.Min.extend(zen_quantifier.min)
                            quantifier.Max.extend(zen_quantifier.max)

        with open(str(resource_data.path), 'wb') as f:
            f.write(quantifiers.SerializeToString())
        resource_data.ready()
