import os

from dj.lib.processing.online.fresh_profile_server.proto import config_pb2
from kernel.server.protos import serverconf_pb2
import google.protobuf.text_format

from sandbox.projects.dj.server import ServerWrapper


def overwrite_port(server_config_path, port):
    server_config_proto = serverconf_pb2.THttpServerConfig()

    with open(server_config_path, 'r') as f:
        google.protobuf.text_format.Parse(f.read(), server_config_proto)

    server_config_proto.Port = port

    tmp_server_config_path = os.path.join(os.getenv('TMP'), 'server.conf')

    with open(tmp_server_config_path, 'w') as f:
        f.write(google.protobuf.text_format.MessageToString(server_config_proto))
    return tmp_server_config_path


def overwrite_logfile(config_path):
    config_proto = config_pb2.TFreshProfileServerConfig()

    with open(config_path, 'r') as f:
        google.protobuf.text_format.Parse(f.read(), config_proto)

    config_proto.ClearField('ProfilesLogFilename')

    tmp_config_path = os.path.join(os.getenv('TMP'), 'config.conf')

    with open(tmp_config_path, 'w') as f:
        f.write(google.protobuf.text_format.MessageToString(config_proto))
    return tmp_config_path


class FreshProfileServer(ServerWrapper):
    name = 'FPS'
    health_path = 'remote_admin?action=health'

    def __init__(self, binary_path, config_path, rules_path, server_config_path, shard_dir):
        super(FreshProfileServer, self).__init__()

        tmp_server_config_path = overwrite_port(server_config_path, self.port)
        tmp_config_path = overwrite_logfile(config_path)

        args = [
            binary_path,
            '--conf', tmp_config_path,
            '--rules_conf', rules_path,
            '--server_conf', tmp_server_config_path,
        ]
        if shard_dir:
            args.extend(['--shard_dir', shard_dir])

        self.start(*args)
