# -*- coding: utf-8 -*-

from contextlib import contextmanager

from sandbox.common import errors
from sandbox.sdk2 import helpers


@contextmanager
def process_wrapper(this, logger):
    try:
        with helpers.ProcessLog(this, logger=logger) as pl:
            yield pl
    except Exception as e:
        raise errors.TaskFailure(e)
