# -*- coding: utf-8 -*-

from sandbox import sdk2

dj_releasers = ["MLMARINES"]


class DjUdf(sdk2.Resource):
    """
    DJ YQL UDF
    """
    calc_md5 = True
    share = True
    auto_backup = True
    releasers = dj_releasers
    releasable = True


class DjNirvanaMakeBin(sdk2.Resource):
    """
    DJ nirvana_make binary
    """
    releasable = True
    executable = True
    releasers = dj_releasers


class DjDoc(sdk2.Resource):
    """
    DJ documentation archive
    """
    calc_md5 = True
    share = True
    auto_backup = True
    releasable = True
    releasers = dj_releasers
    arcadia_build_path = 'dj/docs/docs.tar.gz'


class DjViewer(sdk2.Resource):
    """
    Viewer package
    """
    calc_md5 = True
    share = True
    auto_backup = True
    releasable = True
    releasers = dj_releasers


class DjViewerExecutable(sdk2.Resource):
    releasable = True
    executable = True
    auto_backup = True
    releasers = dj_releasers
    arcadia_build_path = 'dj/tools/viewer/viewer'


class DjViewerFront(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = dj_releasers
    arcadia_build_path = 'dj/lib/viewer/client/viewer.tar.gz'


class DjViewerConfig(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = dj_releasers
    arcadia_build_path = 'dj/tools/viewer/viewer.pbtxt'


class DjNewsOnlineProcessor(sdk2.Resource):
    """
    DJ online processor for news
    """
    releasable = True
    auto_backup = True
    releasers = dj_releasers + ['kcd', 'errorf']
    any_arch = True


class DjEmbeddedYqlArchive(sdk2.Resource):
    """
    Built yql_embedded archive for running YQL nirvana operations in embedded mode
    """
    pass


class DjRtyserverBin(sdk2.Resource):
    """
    DJ rtyserver binary built with DJ basesearch and rearrange.
    """
    releasable = True
    executable = True
    calc_md5 = True
    releasers = dj_releasers


class DjTutorialRtyserverBin(sdk2.Resource):
    """
    DJ rtyserver binary built with DJ basesearch and rearrange.
    """
    releasable = True
    executable = True
    releasers = dj_releasers


class DjTutorialResourceBundle(sdk2.Resource):
    """
    DJ tutorial rtyserver resources.
    """
    releasers = dj_releasers
    releasable = True
    calc_md5 = True


class DjTutorialModels(sdk2.Resource):
    """
    DJ models archive
    """
    releasers = dj_releasers
    releasable = True


class DjTutorialShard(sdk2.Resource):
    """
    DJ tutorial shard
    """
    releasers = dj_releasers + ['cvzakhar']
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class DjCompiledConfig(sdk2.Resource):
    """
    DJ compiled python recommender config
    """
    releasers = dj_releasers + ['cvzakhar']
    releasable = True


class DjAnaconda(sdk2.Resource):
    """
    Anaconda directory for DJ Torch
    """
    calc_md5 = True
    share = True
    auto_backup = True
    releasers = dj_releasers
    releasable = True
